package com.huigou.topsun.proofing.domain.vo;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 作业指导书基本信息
 */
@Data
public class WorkInstructionVo {
    /**
     * 作业指导书id
     */
    private String workInstructionBaseInfoId;

    /**
     * 产品编码
     */
    private String productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品类别
     */
    private String productType;

    /**
     * 产品单位
     */
    private String productUnit;

    /**
     * 尺码组id
     */
    private String sizeGroupId;

    /**
     * 是否为唯一码产品
     */
    private String isOnlyCode;

    /**
     * 是否不考虑形体配色
     */
    private String isBodyColor;

    /**
     * 是否禁用
     */
    private String isDisable;

    /**
     * 是否创建新规格书
     */
    private String isNewSpecification;

    /**
     * 是否建立bom表
     */
    private String isBuildBom;

    /**
     * 确认日期
     */
    private Date confirmDate;

    /**
     * 确认人
     */
    private String comfirmPerson;

    /**
     * 是否免检
     */
    private String isFreeInspection;

    /**
     * 不要质量loss%
     */
    private String isNoQualityLoss;

    /**
     * 样品单号
     */
    private String sampleOrderNo;

    /**
     * 库存编码
     */
    private String stockNo;

    /**
     * 库存名称
     */
    private String stockName;

    /**
     * 存档编号
     */
    private String fileNo;

    /**
     * 品牌
     */
    private String brand;


    private String workInstructionMaterialInfoId;

    /**
     * bom单号
     */
    private String bomNo;

    /**
     * 版本号
     */
    private String versionNo;

    /**
     * 数量
     */
    private Integer number;

    /**
     * 录入人id
     */
    private String createdById;

    /**
     * 录入人名称
     */
    private String createdByName;

    /**
     * 录入日期
     */
    private Date createdDate;

    /**
     * 修改人id
     */
    private String modifiedById;

    /**
     * 修改人名称
     */
    private String modifiedByName;

    /**
     * 修改日期
     */
    private Date modifiedDate;

    /**
     * 状态（启用、禁用）
     */
    private Integer status;

    /**
     * 审核状态
     */
    private String approvalStatus;

    /**
     * 审核人
     */
    private String approvalPerson;

    /**
     * 审核日期
     */
    private Date approvalDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 印张长度(单位cm)
     */
    private Double materialSheetLength;

    /**
     * 印张宽度(单位cm)
     */
    private Double materialSheetWidth;

    /**
     * 满排个数
     */
    private Integer fullNumber;

    /**
     * 损耗百分比(单位%)
     */
    private Double lossRate;

    private String workInstructionOptionalAttributeId;

    /**
     * 制作工厂
     */
    private String makeFactory;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 版面
     */
    private String page;

    /**
     * 材料代号
     */
    private String materialCode;

    /**
     * 产品代号
     */
    private String productCode;

    /**
     * 英文代号
     */
    private String productEnCode;

    /**
     * 型体配色
     */
    private String bodyColor;

    /**
     * 客户料号
     */
    private String customerMaterialCode;

    /**
     * 规格书编号
     */
    private String specificationNo;


    private String workInstructionPdPublishedConfId;

    /**
     * 模数
     */
    private Integer modulus;

    /**
     * 行数
     */
    private Integer rowNum;

    /**
     * 列数
     */
    private Integer columnNum;

    /**
     * 搭版数
     */
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    private Double sheetWidth;

    /**
     * 产品印张设置(product_sheet_conf)
     */
    private String productSheetConf;

    /**
     * 印刷正面颜色
     */
    private String printFrontColer;

    /**
     * 印刷反面颜色
     */
    private String printOppositeColor;

    /**
     * 产品承印物
     */
    private String productSubstrate;

    /**
     * 啤版编号
     */
    private String beerPlateNo;

    /**
     * 烫金版编号
     */
    private String goldPlateNo;

    /**
     * 模切版编号
     */
    private String dieCutPlateNo;

    /**
     * 铜版及树脂版编号
     */
    private String copperpResinLateNo;

    /**
     * 网版编号
     */
    private String netPlateNo;

    /**
     * 工艺制程
     */
    private String technologyProcess;

    /**
     * 产品性质
     */
    private String productProperties;

    /**
     * 工艺要求
     */
    private String technologyRequire;

    /**
     * 包装方式
     */
    private String packageStyle;

    /**
     * 物性测试
     */
    private String physicalTest;

    /**
     * 化性测试
     */
    private String chemistryTest;

    /**
     * 产品材质
     */
    private String productMaterial;

    /**
     * 塑胶袋结构
     */
    private String plasticBagStructure;

    /**
     * 铜版编号
     */
    private String copperpNo;

    /**
     * 色号卡
     */
    private String colorNoCard;

    /**
     * 模具编号
     */
    private String plateNo;

    /**
     * 表面处理
     */
    private String surfaceTreatment;

    /**
     * 产品描述
     */
    private String productDescribe;

    /**
     * 产品正面
     */
    private String productFront;

    /**
     * 产品背面
     */
    private String productOpposite;

    /**
     * 风险描述（序号、内容、等级）
     */
    private String riskDescription;

    /**
     * 是否附样图
     */
    private String haveDrawing;

    /**
     * 是否要鞋图
     */
    private String isShoePicture;

    /**
     * 啤板模数
     */
    private Integer beerPlateNum;

    /**
     * 模切板模数
     */
    private Integer dieBoardNum;

    /**
     * 分切方向
     */
    private String cutDirection;

    /**
     * 海关商品编码
     */
    private String customsCommodityCode;
    /**
     *
     */
    private String workInstructionPrdLookedId;


    /**
     * 长;单位cm
     */
    private Double productLength;

    /**
     * 宽;单位cm
     */
    private Double productWidth;

    /**
     * 高;单位cm
     */
    private Double productHeight;

    /**
     * 厚度;单位mm
     */
    private Double productThick;

    /**
     * 成品克重;单位g
     */
    private Double productWeight;

    /**
     * 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；
     */
    private String productShape;

    /**
     * 孔径(单位mm)
     */
    private Double productAperture;

    /**
     * 单层厚(单位丝)
     */
    private Integer productSingleLayer;

    /**
     * 单重(单位KG)
     */
    private Double productSingleWeight;

    /**
     * 层数
     */
    private Integer productLayerNum;

    /**
     * 是否防霉(is_open)
     */
    private String productMould;

    /**
     * 是否写码(is_open)
     */
    private String productCoding;

    /**
     * 体系认证(product_sys_certification)
     */
    private String productSysCertification;

    /**
     * 仓库(store_name)
     */
    private String storeName;
    /**
     * 采购单位(product_buy_unit)
     */
    private String productBuyUnit;
    /**
     * 换算值
     */
    private String matrixingValue;

    /**
     * 产品lossID
     */
    private Long productLossId;

    /**
     * 产品最大loss数量
     */
    private Integer productLossMax;

    /**
     * loss比率(单位%)
     */
    private Double productLossRate;

    /**
     * 冗余量
     */
    private Double productLossRedundance;

    /**
     * 备注信息
     */
    private String productLossRemark;


    /**
     * 新增分段
     */
    private String productAddSection;

    /**
     * 删除分段
     */
    private String productDeleteSection;

}