package com.huigou.topsun.product.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 尺码组尺码明细
 * @TableName size_group_item
 */
@Table(name="size_group_item")
@Entity
@Data
public class SizeGroupItem implements Serializable {
    /**
     * 尺码id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "size_group_item_id")
    private String sizeGroupItemId;

    /**
     * 尺码组id
     */
    @Column(name = "size_group_id")
    private String sizeGroupId;

    /**
     * 尺码名称
     */
    @Column(name = "size_group_item_name")
    private String sizeGroupItemName;

    /**
     * 显示顺序
     */
    @Column(name = "size_group_item_sequence")
    private Integer sizeGroupItemSequence;

    /**
     * 备注
     */
    @Column(name = "size_group_item_remark")
    private String sizeGroupItemRemark;

    private static final long serialVersionUID = 1L;
}