package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 产品物料组成
 * @TableName product_material
 */
@Table(name="product_material")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductMaterial implements Serializable {
    /**
     * 产品物料组成ID
     */
    @Id
    @Column(name = "product_material_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productMaterialId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productId;

    /**
     * 物料ID
     */
    @Column(name = "material_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal materialId;

    /**
     * 物料数量
     */
    @Column(name = "material_number")
    private Integer materialNumber;

    /**
     * BOM版本
     */
    @Column(name = "bom_version")
    private String bomVersion;

    /**
     * 产品BOM类型(bom_type)
     */
    @Column(name = "bom_type")
    private String bomType;

    public BigDecimal getProductMaterialId() {
        return productMaterialId;
    }

    public void setProductMaterialId(String productMaterialId) {
        this.productMaterialId = (productMaterialId != null) ? new BigDecimal(productMaterialId) : null;
    }

    public BigDecimal getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = (productId != null) ? new BigDecimal(productId) : null;
    }

    public BigDecimal getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = (materialId != null) ? new BigDecimal(materialId) : null;
    }

    public Integer getMaterialNumber() {
        return materialNumber;
    }

    public void setMaterialNumber(Integer materialNumber) {
        this.materialNumber = materialNumber;
    }

    public String getBomVersion() {
        return bomVersion;
    }

    public void setBomVersion(String bomVersion) {
        this.bomVersion = bomVersion;
    }

    public String getBomType() {
        return bomType;
    }

    public void setBomType(String bomType) {
        this.bomType = bomType;
    }
}