package com.huigou.topsun.customer.application.Impl;


import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.customer.application.CustomerApplication;
import com.huigou.topsun.customer.domain.CustomerContact;
import com.huigou.topsun.customer.domain.query.CustomerQueryRequest;
import com.huigou.topsun.customer.repository.CustomerContactRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;


@Service
public class CustomerApplicationImpl extends BaseApplication implements CustomerApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";
    @Autowired
    private CustomerContactRepository customerContactRepository;


    /**
     * 分页查询客户信息数据
     * @param customerQueryRequest
     * @return
     */
    @Override
    public Map<String, Object> findCustomerByPage(CustomerQueryRequest customerQueryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "customerList");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, customerQueryRequest);
        return this.sqlExecutorDao.executeSlicedQuery(model);
    }

    /**
     * 分页查询联系人信息
     * @param customerId
     * @return
     */
    @Override
    public List<CustomerContact> findContactByPage(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "contactList");
        List<CustomerContact> customerContactList = this.sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerContact.class, customerId);
        return customerContactList;
    }

    /**
     * 根据单个id删除
     * @param id
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void deleteContactById(String id) {
        customerContactRepository.delete(id);
    }

    /**
     * 批量进行删除
     * @param ids
     */

    @Override
    @Transactional
    public void deleteContactByIds(List<String> ids) {
        ids.forEach(this::deleteContactById);
    }
}
