var gridManager = null, refreshFlag = false;
$(document).ready(function() {
	initializeGrid();
});

//初始化表格
function initializeGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({ 
		addHandler: addHandler, 
		updateHandler: function(){
			updateHandler();
		},
		deleteHandler: deleteHandler,
		enableHandler: enableHandler,
		disableHandler: disableHandler,
		syncCache:{id:'syncCache',text:'topsun.AttachmentExplain.link',img:'fa-link',click:function(){
			var url=DataUtil.composeURLByParam('attachmentExplain/showAttachmentExplainList.do',{});
			UICtrl.addTabItem({tabid:'attachmentExplainLink', text:$.i18nProp('topsun.AttachmentExplain.link'),url:url});
		}},
		hxManagementMethods:{id:'hxManagementMethods',text:'管理办法上传',img:'fa-link',click:function(){
			UICtrl.showAjaxDialog({
				url: web_app.name+'/attachmentExplain/showAttachmentManagementMethods.load',
				title:'管理办法上传',
				width:600,
				init:function(div){
					$('#attachmentList',div).fileList();
				},
				ok:false
			});
		}}
	});
	gridManager = UICtrl.grid('#maingrid', {
		columns: [
		   
		{ display: "common.field.code", name: "code", width: 150, minWidth: 60, type: "string", align: "left" },		   
		{ display: "common.field.name", name: "name", width: 260, minWidth: 60, type: "string", align: "left" },
		{ display : "common.field.status", name: "status", width: 80, minWidth: 60, type: "string", align: "left",
            render: function (item) {
            	if(item.status==true){
            		return UICtrl.getStatusInfo(1);
            	}else{
            		return UICtrl.getStatusInfo(0);
            	}
            }
        }
		],
		dataAction : 'server',
		url: web_app.name+'/attachmentExplain/slicedQueryAttachmentExplain.ajax',
		checkbox: true,
		width : '100%',
		height : '100%',
		heightDiff : -5,
		sortName:'code',
		sortOrder:'asc',
		toolbar: toolbarOptions,
		onDblClickRow : function(data, rowindex, rowobj) {
			updateHandler(data.id);
		}
	});
	UICtrl.setSearchAreaToggle(gridManager);
}

// 查询
function query(obj) {
	var param = $(obj).formToJSON();
	UICtrl.gridSearch(gridManager, param);
}

//刷新表格
function reloadGrid() {
	gridManager.loadData();
} 

//重置表单
function resetForm(obj) {
	$(obj).formClean();
}

//关闭对话框
function dialogClose(){
	if(refreshFlag){
		reloadGrid();
		refreshFlag=false;
	}
}

//添加按钮
function addHandler() {
	UICtrl.showAjaxDialog({
		title: $.i18nProp('common.field.add.title', $.i18nProp("topsun.AttachmentExplain.title")),
		url : web_app.name + '/attachmentExplain/showInsertAttachmentExplain.load',
		ok : insert,
		width : 800,
		close : dialogClose
	});
}

//新增保存
function insert() {
	var _self=this;
	$('#submitForm').ajaxSubmit({
		url : web_app.name + '/attachmentExplain/insertAttachmentExplain.ajax',
		success : function(data) {
			_self.close();
			reloadGrid();
		}
	});
}

//编辑按钮
function updateHandler(id) {
    if (!id) {
        var id = DataUtil.getUpdateRowId(gridManager);
        if (!id) {
            return;
        }
    }
    UICtrl.showAjaxDialog({
        title: $.i18nProp('common.field.modif.title', $.i18nProp("ssrf.AttachmentExplain.title")),
        width: 800,
        url: web_app.name + '/attachmentExplain/showLoadAttachmentExplain.load',
        param: {id: id},
        ok: update,
        close:dialogClose
    });
}

//编辑保存
function update() {
	var _self=this;
	$('#submitForm').ajaxSubmit({
		url : web_app.name + '/attachmentExplain/updateAttachmentExplain.ajax',
		success : function() {
			refreshFlag = true;
			_self.close();
		}
	});
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'attachmentExplain/deleteAttachmentExplain.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

//启用
function enableHandler(){
	DataUtil.updateById({ action: 'attachmentExplain/updateAttachmentExplainStatus.ajax',
		gridManager: gridManager,idFieldName:'id', param:{status:1},
		message:'common.confirm.enable',
		onSuccess:function(){
			reloadGrid();	
		}
	});		
}
//禁用
function disableHandler(){
	DataUtil.updateById({ action: 'attachmentExplain/updateAttachmentExplainStatus.ajax',
		gridManager: gridManager,idFieldName:'id',param:{status:0},
		message: 'common.confirm.disable',
		onSuccess:function(){
			reloadGrid();	
		}
	});		
}

