package com.huigou.topsun.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * EntityConvertUtil 数据类型转换工具
 *
 * @author qinzhenguan
 * @createDate 2023/12/30 10:56
 **/
public class EntityConvertUtil {

    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();


    /**
     * description 返回页面 Form 所需的数据格式
     * @param entitys   所有相关的 实体。 必须为 JavaBean 调用了 .getClass().getSimpleName()
     * @return java.util.HashMap<java.lang.String, java.lang.Object>
     * @author qinzhenguan
     * @createDate 2023/12/5 14:09
     */
    public static Map<String, Object> assembleResultOfForm(Set<Object> entitys) {
        Map<String, Object> map = new HashMap<>(256);
        for(Object item : entitys) {
            if(item == null) {
                continue;
            }
            if(item instanceof List) {
                if(((List<?>) item).size() > 0) {
                    map.put((((List<?>) item).get(0)).getClass().getSimpleName(), OBJECT_MAPPER.convertValue(item, List.class));
                }
            } else {
                map.put(item.getClass().getSimpleName(), OBJECT_MAPPER.convertValue(item, new TypeReference<Map<? extends String, ?>>() {}) );
            }
            // 这里要获取所有的属性名， 保存对应关系， 属性： 所属实体类；
            //map.putAll(mapper.convertValue(item, new TypeReference<Map<? extends String, ?>>() {}));
        }
        return map;
    }

    /**
     * description
     * @param clazz Bean
     * @param displayProperty   需要显示的属性
     * @param valueProperty     连接的属性
     * @param list  需要转换的 List
     * @return java.util.Map<java.lang.Object, java.lang.Object>
     * @author qinzhenguan
     * @createDate 2023/12/1 16:09
     */
    public static Map<Object, Object> convertToMap(Class<?> clazz, String displayProperty, String valueProperty,
                                            List<?> list) {
        Set<String> set = new HashSet<>();
        set.add(displayProperty);
        set.add(valueProperty);
        if(checkClassesAndProperties(clazz, set, list.size())) {

            LinkedList<Map<String, Object>> mapList = OBJECT_MAPPER.convertValue(list, new TypeReference<LinkedList<Map<String, Object>>>() {});
            return mapList.stream().collect(Collectors.toMap(map -> map.get(displayProperty), map -> map.get(valueProperty),
                    (oldV, newV) -> oldV));
        }
        return null;
    }

    /**
     * description  只检查传入属性是否合法
     * @param clazz Bean
     * @param set   需要检查的 Propertys
     * @param listSize  需要检查的 ListSize
     * @return java.lang.Boolean    true of false
     * @author qinzhenguan
     * @createDate 2023/12/1 15:58
     */
    public static Boolean checkClassesAndProperties(Class<?> clazz, Set<String> set, int listSize) {
        if(listSize == 0) {
            System.err.println("[checkClassesAndProperties] :  List< "+clazz.getName()+" > 需要转换的列表没有元素。请检查~！");
            return false;
        }
        Field[] fields = clazz.getDeclaredFields();
        Method[] methods = clazz.getDeclaredMethods();
        for(String item : set) {
            Field field = Arrays.stream(fields).filter(f -> item.equals(f.getName())).findFirst().orElse(null);
            if(field == null) {
                System.err.println("[checkClassesAndProperties] : " + clazz.getName() + " 无法找到 ： " + item + " " +
                        "该属性。请检查~！");
                return false;
            }
            Method method = Arrays.stream(methods)
                    .filter(m -> m.getName().toLowerCase().contains("get" + item.toLowerCase())).findFirst().orElse(null);
            if (method == null) {
                System.err.println("[checkClassesAndProperties] : " + item + " 该属性无法找到构造方法。请检查~！");
                return false;
            }
        }
        return true;
    }

    /**
     * description 转换成 Map 不需要转换为实体
     * @param clazz Bean
     * @param propertyName 连接的 property
     * @param list  需要转换的 List
     * @return java.util.Map<java.lang.Object, java.lang.Object>
     * @author qinzhenguan
     * @createDate 2023/11/29 11:36
     */
    public static Map<Object, Object> convertToMap(Class<?> clazz, String propertyName, List<?> list) {
        return convertToMap(clazz, propertyName, list, false);
    }

    /**
     * description 转换成 Map 保留映射
     * @param clazz Bean
     * @param propertyName  连接的 property
     * @param list  需要转换的 List
     * @param isBean    是否需要转换为实体 （当前应用不需要返回实体）
     * @return java.util.Map<java.lang.Object, java.lang.Object>
     * @author qinzhenguan
     * @createDate 2023/11/29 11:34
     */
    public static Map<Object, Object> convertToMap(Class<?> clazz, String propertyName, List<?> list, boolean isBean) {
        Map<String, Object> checkMap = checkClassesAndProperties(clazz, propertyName, list.size());
        String ok = "isOk";
        if(!(Boolean) checkMap.get(ok)) {
            return null;
        }
        Method method = (Method) checkMap.get("method");

        LinkedList<Map<String, Object>> mapList = OBJECT_MAPPER.convertValue(list, new TypeReference<LinkedList<Map<String, Object>>>() {});
        Map<Object, Object> resultMap = new HashMap<>(10);
        Map<Object, Object> convert = new HashMap<>(1024);
        if(isBean) {
            // ---------------------------------  实体 ---------------------------------
            try {
                for (int i = 0; i < mapList.size(); i++) {
                    Object o = clazz.newInstance();
                    BeanUtils.populate(o, mapList.get(i));
                    Object key = method.invoke(o);
                    convert.put(key, o);
                }
            } catch (InstantiationException | IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            // ---------------------------------  非实体 ---------------------------------
            convert = mapList.stream().collect(Collectors.toMap(map -> map.get(propertyName), Function.identity(),
                    (oldV, newV) -> oldV));
            //此处仍需处理 Key == null;
        }
        resultMap.put("map", convert);
        resultMap.put("list", list);
        return resultMap;
    }

    /**
     * description 检查传入参数是否合法 并返回构造方法
     *
     * @param clazz javaBean
     * @param propertyName property
     * @return java.util.HashMap<java.lang.String, java.lang.Object> { "isOk" : 是否通过检查, "method"：获取得到的 method }
     * @author qinzhenguan
     * @createDate 2023/11/29 11:05
     */
    public static HashMap<String, Object> checkClassesAndProperties(Class<?> clazz, String propertyName, int listSize) {
        HashMap<String, Object> map = new HashMap<>(33);
        if(listSize == 0) {
            System.err.println("[checkClassesAndProperties] :  List< "+clazz.getName()+" > 需要转换的列表没有元素。请检查~！");
            map.put("isOk", false);
            return map;
        }
        Field[] fields = clazz.getDeclaredFields();
        Field field = Arrays.stream(fields).filter(f -> propertyName.equals(f.getName())).findFirst().orElse(null);
        if(field == null) {
            System.err.println("[checkClassesAndProperties] : " + clazz.getName() + " 无法找到 ： " + propertyName + " " +
                    "该属性。请检查~！");
            map.put("isOk", false);
            return map;
        }
        Method[] methods = clazz.getDeclaredMethods();
        Method method = Arrays.stream(methods)
                .filter(m -> m.getName().toLowerCase().contains("get" + propertyName.toLowerCase())).findFirst().orElse(null);
        if (method == null) {
            System.err.println("[checkClassesAndProperties] : " + propertyName + " 该属性无法找到构造方法。请检查~！");
            map.put("isOk", false);
            return map;
        }
        map.put("isOk", true);
        map.put("method", method);
        return map;
    }

}