package com.huigou.topsun.technology.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.data.domain.query.QueryAbstractRequest;
import com.huigou.topsun.technology.domain.model.Technology;
import lombok.Data;

import java.io.Serializable;

/**
 * 工艺
 * @TableName technology
 */
@Data
public class TechnologyVo implements Serializable {
    /**
     * 工艺路线ID
     */
    private String technologyId;

    /**
     * 工艺路线名称
     */
    private String technologyName;

    /**
     * 产品ID
     */
    private String productId;

    /**
     * 工艺版本
     */
    private String technologyVersion;

    /**
     * 工艺类型(technology_type)
     */
    private String technologyType;

    public static TechnologyVo getTechnologyVo(Technology technology){
        return JSON.parseObject(JSON.toJSONString(technology),TechnologyVo.class);
    }

    public static Technology getTechnology(TechnologyVo technologyVo){
        return JSON.parseObject(JSON.toJSONString(technologyVo),Technology.class);
    }
}