package com.huigou.topsun.technology.controller;

import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.query.TechnologyProcessQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/11/23/16:56
 * @Description:
 */
@Controller
@ControllerMapping("/technologyProcess")
public class TechnologyProcessController extends CommonController {

    @Resource
    private TechnologyProcessApplication technologyProcessApplication;

    public String slicedTechnologyProcessList(){
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("technologyId");
        return packGridDataAndResult(technologyProcessApplication.slicedTechnologyProcessList(technologyId));
    }

    public String slicedProcessForProduct(){
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("technologyId");
        Map<String, Object> map = new HashMap<>();
        TechnologyProcessQueryRequest queryRequest = sdo.toQueryRequest(TechnologyProcessQueryRequest.class);
        if (StringUtil.isNotBlank(technologyId)){
            queryRequest.setTechnologyId(technologyId);
            map = technologyProcessApplication.slicedProcessForProduct(queryRequest);
        }
        return toResult(map);
    }

    public String deleteTechnologyProcess(){
        SDO sdo = this.getSDO();
        List<String> technologyProcessIds = sdo.getIds();
        return success();
    }
}
