package com.huigou.topsun.sap.workcenter.domain;

import java.io.Serializable;

import java.math.BigDecimal;
import javax.persistence.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * @author qinzhenguan
 * null
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "sys_change_record")
public class SysChangeRecord implements Serializable {

	/**
	 * null
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "id", nullable = false)
	private BigDecimal id;

	/**
	 * 关联数据ID
	 */
	@Column(name = "correlation_id", nullable = true, length = 32)
	private String correlationId;

	/**
	 * 关联系统
	 */
	@Column(name = "correlation_system", nullable = true, length = 32)
	private String correlationSystem;

	/**
	 * 业务ID
	 */
	@Column(name = "business_id", nullable = true, length = 32)
	private String businessId;

	/**
	 * 业务名称
	 */
	@Column(name = "business_name", nullable = true, length = 100)
	private String businessName;

	/**
	 * 归属部门
	 */
	@Column(name = "depart", nullable = true, length = 64)
	private String depart;

	/**
	 * 录入人
	 */
	@Column(name = "enter_user", nullable = true, length = 120)
	private String enterUser;

	/**
	 * 录入时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Column(name = "enter_time", nullable = true)
	private java.util.Date enterTime;

	/**
	 * 最后修改人
	 */
	@Column(name = "last_reviser", nullable = true, length = 120)
	private String lastReviser;

	/**
	 * 最后修改时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@Column(name = "last_reviser_time", nullable = true)
	private java.util.Date lastReviserTime;

	/**
	 * 有效标志： 0：false；1：true
	 */
	@Column(name = "yxbz", nullable = true)
	private Integer yxbz;

	@Override
	public boolean equals(Object o) {
		if (this == o) { return true; }
		if (o == null || getClass() != o.getClass()) { return false; }
		SysChangeRecord that = (SysChangeRecord) o;
		return new EqualsBuilder().append(id, that.id).append(correlationId, that.correlationId).append(correlationSystem, that.correlationSystem).append(businessId, that.businessId).append(businessName, that.businessName).append(depart, that.depart).append(enterUser, that.enterUser).append(enterTime, that.enterTime).append(lastReviser, that.lastReviser).append(lastReviserTime, that.lastReviserTime).append(yxbz, that.yxbz).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(id).append(correlationId).append(correlationSystem).append(businessId).append(businessName).append(depart).append(enterUser).append(enterTime).append(lastReviser).append(lastReviserTime).append(yxbz).toHashCode();
	}

	public BigDecimal getId() {
		return this.id;
	}
	
	public void setId (String  id) {
		this.id = (id == null) || id.isEmpty() ? null : new BigDecimal(id);
	}
	
	public String getCorrelationId() {
		return this.correlationId;
	}
	
	public void setCorrelationId(String correlationId) {
		this.correlationId = correlationId;
	}
	
	public String getCorrelationSystem() {
		return this.correlationSystem;
	}
	
	public void setCorrelationSystem(String correlationSystem) {
		this.correlationSystem = correlationSystem;
	}
	
	public String getBusinessId() {
		return this.businessId;
	}
	
	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}
	
	public String getBusinessName() {
		return this.businessName;
	}
	
	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}
	
	public String getDepart() {
		return this.depart;
	}
	
	public void setDepart(String depart) {
		this.depart = depart;
	}
	
	public String getEnterUser() {
		return this.enterUser;
	}
	
	public void setEnterUser(String enterUser) {
		this.enterUser = enterUser;
	}
	
	public java.util.Date getEnterTime() {
		return this.enterTime;
	}
	
	public void setEnterTime(java.util.Date enterTime) {
		this.enterTime = enterTime;
	}
	
	public String getLastReviser() {
		return this.lastReviser;
	}
	
	public void setLastReviser(String lastReviser) {
		this.lastReviser = lastReviser;
	}
	
	public java.util.Date getLastReviserTime() {
		return this.lastReviserTime;
	}
	
	public void setLastReviserTime(java.util.Date lastReviserTime) {
		this.lastReviserTime = lastReviserTime;
	}
	
	public Integer getYxbz() {
		return this.yxbz;
	}
	
	public void setYxbz(Integer yxbz) {
		this.yxbz = yxbz;
	}
}
