package com.huigou.topsun.sap.workcenter.domain;

import java.io.Serializable;

import java.math.BigDecimal;
import javax.persistence.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @author YourUserName
 * 工作中心
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "sap_work_center")
public class SapWorkCenter implements Serializable {

	/**
	 * 主键id
	 */
	@Id
	@Column(name = "id", nullable = false, length = 32)
	private String id;

	/**
	 * 工厂
	 */
	@Column(name = "WERKS", nullable = true, length = 32)
	private String werks;

	/**
	 * 工作中心
	 */
	@Column(name = "APBPL", nullable = true, length = 32)
	private String apbpl;

	/**
	 * 工作中心类型
	 */
	@Column(name = "VERWE", nullable = true, length = 32)
	private String verwe;

	/**
	 * 工作中心描述
	 */
	@Column(name = "STEXT", nullable = true, length = 255)
	private String stext;

	/**
	 * 任务清单使用码
	 */
	@Column(name = "PLANV", nullable = true, length = 255)
	private String planv;

	/**
	 * 工作中心负责人
	 */
	@Column(name = "VERAN", nullable = true, length = 255)
	private String veran;

	/**
	 * 标志：倒冲
	 */
	@Column(name = "RGEKZ", nullable = true, length = 255)
	private String rgekz;

	/**
	 * 标准值码
	 */
	@Column(name = "VORGSCHL", nullable = true, length = 255)
	private String vorgschl;

	/**
	 * 控制码
	 */
	@Column(name = "STEUS", nullable = true, length = 255)
	private String steus;

	/**
	 * 产能短文本
	 */
	@Column(name = "KTEXT", nullable = true, length = 255)
	private String ktext;

	/**
	 * 能力类别
	 */
	@Column(name = "KAPART", nullable = true, length = 255)
	private String kapart;

	/**
	 * 产能负责计划员组
	 */
	@Column(name = "PLANR", nullable = true, length = 255)
	private String planr;

	/**
	 * 工厂日历标识
	 */
	@Column(name = "KALID", nullable = true)
	private Integer kalid;

	/**
	 * 产能基本计量单位
	 */
	@Column(name = "MEINS", nullable = true, length = 255)
	private String meins;

	/**
	 * 开始时间
	 */
	@Column(name = "BEGZT", nullable = true, length = 255)
	private String begzt;

	/**
	 * 结束时间
	 */
	@Column(name = "ENDZT", nullable = true, length = 255)
	private String endzt;

	/**
	 * 产能利用率（百分比）
	 */
	@Column(name = "NGRAD", nullable = true, length = 255)
	private String ngrad;

	/**
	 * 单个产能数
	 */
	@Column(name = "AZNOR", nullable = true, length = 255)
	private String aznor;

	/**
	 * 产能计量单位
	 */
	@Column(name = "KAPEH", nullable = true, length = 255)
	private String kapeh;

	/**
	 * 标识：产能与有限计划相关
	 */
	@Column(name = "KAPTER", nullable = true, length = 255)
	private String kapter;

	/**
	 * 过载
	 */
	@Column(name = "UEBERLAST", nullable = true, length = 255)
	private String ueberlast;

	/**
	 * 用于处理产能需求的公式
	 */
	@Column(name = "FORK2", nullable = true, length = 255)
	private String fork2;

	/**
	 * 计划能力类别
	 */
	@Column(name = "KAPART_JH", nullable = true, length = 255)
	private String kapartJh;

	/**
	 * 加工时间的时间期限公式
	 */
	@Column(name = "FORT2", nullable = true, length = 255)
	private String fort2;

	/**
	 * 开始日期
	 */
	@Column(name = "BEGDA", nullable = true, length = 255)
	private String begda;

	/**
	 * 结束日期
	 */
	@Column(name = "ENDDA", nullable = true, length = 255)
	private String endda;

	/**
	 * 成本中心
	 */
	@Column(name = "KOSTL", nullable = true, length = 255)
	private String kostl;

	/**
	 * 活动类型1
	 */
	@Column(name = "LSTAR1", nullable = true, length = 255)
	private String lstar1;

	/**
	 * 作业单位1
	 */
	@Column(name = "LEINH1", nullable = true, length = 255)
	private String leinh1;

	/**
	 * 公式码用于成本核算1
	 */
	@Column(name = "FORML1", nullable = true, length = 255)
	private String forml1;

	/**
	 * 活动类型2
	 */
	@Column(name = "LSTAR2", nullable = true, length = 255)
	private String lstar2;

	/**
	 * 作业单位2
	 */
	@Column(name = "LEINH2", nullable = true, length = 255)
	private String leinh2;

	/**
	 * 公式码用于成本核算2
	 */
	@Column(name = "FORML2", nullable = true, length = 255)
	private String forml2;

	/**
	 * 活动类型3
	 */
	@Column(name = "LSTAR3", nullable = true, length = 255)
	private String lstar3;

	/**
	 * 作业单位3
	 */
	@Column(name = "LEINH3", nullable = true, length = 255)
	private String leinh3;

	/**
	 * 公式码用于成本核算3
	 */
	@Column(name = "FORML3", nullable = true, length = 255)
	private String forml3;

	/**
	 * 活动类型4
	 */
	@Column(name = "LSTAR4", nullable = true, length = 255)
	private String lstar4;

	/**
	 * 作业单位4
	 */
	@Column(name = "LEINH4", nullable = true, length = 255)
	private String leinh4;

	/**
	 * 公式码用于成本核算4
	 */
	@Column(name = "FORML4", nullable = true, length = 255)
	private String forml4;

	/**
	 * 活动类型5
	 */
	@Column(name = "LSTAR5", nullable = true, length = 255)
	private String lstar5;

	/**
	 * 作业单位5
	 */
	@Column(name = "LEINH5", nullable = true, length = 255)
	private String leinh5;

	/**
	 * 公式码用于成本核算5
	 */
	@Column(name = "FORML5", nullable = true, length = 255)
	private String forml5;

	/**
	 * 活动类型6
	 */
	@Column(name = "LSTAR6", nullable = true, length = 255)
	private String lstar6;

	/**
	 * 作业单位6
	 */
	@Column(name = "LEINH6", nullable = true, length = 255)
	private String leinh6;

	/**
	 * 公式码用于成本核算6
	 */
	@Column(name = "FORML6", nullable = true, length = 255)
	private String forml6;

	/**
	 * 第一工作中心参数（用于公式）
	 */
	@Column(name = "PAR01", nullable = true, length = 255)
	private String par01;

	/**
	 * 参数值1
	 */
	@Column(name = "PARV1", nullable = true, length = 255)
	private String parv1;

	/**
	 * 第二个工作中心参数 （用于公式）
	 */
	@Column(name = "PAR02", nullable = true, length = 255)
	private String par02;

	/**
	 * 参数值2
	 */
	@Column(name = "PARV2", nullable = true, length = 255)
	private String parv2;

	/**
	 * 第三个工作中心参数 (用于公式)
	 */
	@Column(name = "PAR03", nullable = true, length = 255)
	private String par03;

	/**
	 * 参数值3
	 */
	@Column(name = "PARV3", nullable = true, length = 255)
	private String parv3;

	/**
	 * 第四工作中心参数（用于公式）
	 */
	@Column(name = "PAR04", nullable = true, length = 255)
	private String par04;

	/**
	 * 参数值4
	 */
	@Column(name = "PARV4", nullable = true, length = 255)
	private String parv4;

	/**
	 * 第五工作中心参数（用于公式）
	 */
	@Column(name = "PAR05", nullable = true, length = 255)
	private String par05;

	/**
	 * 参数值5
	 */
	@Column(name = "PARV5", nullable = true, length = 255)
	private String parv5;

	/**
	 * 第六个工作中心参数 ( 用于公式 )
	 */
	@Column(name = "PAR06", nullable = true, length = 255)
	private String par06;

	/**
	 * 参数值6
	 */
	@Column(name = "PARV6", nullable = true, length = 255)
	private String parv6;

	/**
	 * 参照标识
	 */
	@Column(name = "LSTAR_REF1", nullable = true, length = 255)
	private String lstarRef1;

	/**
	 * 备注
	 */
	@Column(name = "ZBZ", nullable = true, length = 255)
	private String zbz;

	/**
	 * 更新标识:I 插入 U 修改 D 删除
	 */
	@Column(name = "UPDKZ", nullable = true, length = 255)
	private String updkz;
	
	public String getId() {
		return this.id;
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	public String getWerks() {
		return this.werks;
	}
	
	public void setWerks(String werks) {
		this.werks = werks;
	}
	
	public String getApbpl() {
		return this.apbpl;
	}
	
	public void setApbpl(String apbpl) {
		this.apbpl = apbpl;
	}
	
	public String getVerwe() {
		return this.verwe;
	}
	
	public void setVerwe(String verwe) {
		this.verwe = verwe;
	}
	
	public String getStext() {
		return this.stext;
	}
	
	public void setStext(String stext) {
		this.stext = stext;
	}
	
	public String getPlanv() {
		return this.planv;
	}
	
	public void setPlanv(String planv) {
		this.planv = planv;
	}
	
	public String getVeran() {
		return this.veran;
	}
	
	public void setVeran(String veran) {
		this.veran = veran;
	}
	
	public String getRgekz() {
		return this.rgekz;
	}
	
	public void setRgekz(String rgekz) {
		this.rgekz = rgekz;
	}
	
	public String getVorgschl() {
		return this.vorgschl;
	}
	
	public void setVorgschl(String vorgschl) {
		this.vorgschl = vorgschl;
	}
	
	public String getSteus() {
		return this.steus;
	}
	
	public void setSteus(String steus) {
		this.steus = steus;
	}
	
	public String getKtext() {
		return this.ktext;
	}
	
	public void setKtext(String ktext) {
		this.ktext = ktext;
	}
	
	public String getKapart() {
		return this.kapart;
	}
	
	public void setKapart(String kapart) {
		this.kapart = kapart;
	}
	
	public String getPlanr() {
		return this.planr;
	}
	
	public void setPlanr(String planr) {
		this.planr = planr;
	}
	
	public Integer getKalid() {
		return this.kalid;
	}
	
	public void setKalid(Integer kalid) {
		this.kalid = kalid;
	}
	
	public String getMeins() {
		return this.meins;
	}
	
	public void setMeins(String meins) {
		this.meins = meins;
	}
	
	public String getBegzt() {
		return this.begzt;
	}
	
	public void setBegzt(String begzt) {
		this.begzt = begzt;
	}
	
	public String getEndzt() {
		return this.endzt;
	}
	
	public void setEndzt(String endzt) {
		this.endzt = endzt;
	}
	
	public String getNgrad() {
		return this.ngrad;
	}
	
	public void setNgrad(String ngrad) {
		this.ngrad = ngrad;
	}
	
	public String getAznor() {
		return this.aznor;
	}
	
	public void setAznor(String aznor) {
		this.aznor = aznor;
	}
	
	public String getKapeh() {
		return this.kapeh;
	}
	
	public void setKapeh(String kapeh) {
		this.kapeh = kapeh;
	}
	
	public String getKapter() {
		return this.kapter;
	}
	
	public void setKapter(String kapter) {
		this.kapter = kapter;
	}
	
	public String getUeberlast() {
		return this.ueberlast;
	}
	
	public void setUeberlast(String ueberlast) {
		this.ueberlast = ueberlast;
	}
	
	public String getFork2() {
		return this.fork2;
	}
	
	public void setFork2(String fork2) {
		this.fork2 = fork2;
	}
	
	public String getKapartJh() {
		return this.kapartJh;
	}
	
	public void setKapartJh(String kapartJh) {
		this.kapartJh = kapartJh;
	}
	
	public String getFort2() {
		return this.fort2;
	}
	
	public void setFort2(String fort2) {
		this.fort2 = fort2;
	}
	
	public String getBegda() {
		return this.begda;
	}
	
	public void setBegda(String begda) {
		this.begda = begda;
	}
	
	public String getEndda() {
		return this.endda;
	}
	
	public void setEndda(String endda) {
		this.endda = endda;
	}
	
	public String getKostl() {
		return this.kostl;
	}
	
	public void setKostl(String kostl) {
		this.kostl = kostl;
	}
	
	public String getLstar1() {
		return this.lstar1;
	}
	
	public void setLstar1(String lstar1) {
		this.lstar1 = lstar1;
	}
	
	public String getLeinh1() {
		return this.leinh1;
	}
	
	public void setLeinh1(String leinh1) {
		this.leinh1 = leinh1;
	}
	
	public String getForml1() {
		return this.forml1;
	}
	
	public void setForml1(String forml1) {
		this.forml1 = forml1;
	}
	
	public String getLstar2() {
		return this.lstar2;
	}
	
	public void setLstar2(String lstar2) {
		this.lstar2 = lstar2;
	}
	
	public String getLeinh2() {
		return this.leinh2;
	}
	
	public void setLeinh2(String leinh2) {
		this.leinh2 = leinh2;
	}
	
	public String getForml2() {
		return this.forml2;
	}
	
	public void setForml2(String forml2) {
		this.forml2 = forml2;
	}
	
	public String getLstar3() {
		return this.lstar3;
	}
	
	public void setLstar3(String lstar3) {
		this.lstar3 = lstar3;
	}
	
	public String getLeinh3() {
		return this.leinh3;
	}
	
	public void setLeinh3(String leinh3) {
		this.leinh3 = leinh3;
	}
	
	public String getForml3() {
		return this.forml3;
	}
	
	public void setForml3(String forml3) {
		this.forml3 = forml3;
	}
	
	public String getLstar4() {
		return this.lstar4;
	}
	
	public void setLstar4(String lstar4) {
		this.lstar4 = lstar4;
	}
	
	public String getLeinh4() {
		return this.leinh4;
	}
	
	public void setLeinh4(String leinh4) {
		this.leinh4 = leinh4;
	}
	
	public String getForml4() {
		return this.forml4;
	}
	
	public void setForml4(String forml4) {
		this.forml4 = forml4;
	}
	
	public String getLstar5() {
		return this.lstar5;
	}
	
	public void setLstar5(String lstar5) {
		this.lstar5 = lstar5;
	}
	
	public String getLeinh5() {
		return this.leinh5;
	}
	
	public void setLeinh5(String leinh5) {
		this.leinh5 = leinh5;
	}
	
	public String getForml5() {
		return this.forml5;
	}
	
	public void setForml5(String forml5) {
		this.forml5 = forml5;
	}
	
	public String getLstar6() {
		return this.lstar6;
	}
	
	public void setLstar6(String lstar6) {
		this.lstar6 = lstar6;
	}
	
	public String getLeinh6() {
		return this.leinh6;
	}
	
	public void setLeinh6(String leinh6) {
		this.leinh6 = leinh6;
	}
	
	public String getForml6() {
		return this.forml6;
	}
	
	public void setForml6(String forml6) {
		this.forml6 = forml6;
	}
	
	public String getPar01() {
		return this.par01;
	}
	
	public void setPar01(String par01) {
		this.par01 = par01;
	}
	
	public String getParv1() {
		return this.parv1;
	}
	
	public void setParv1(String parv1) {
		this.parv1 = parv1;
	}
	
	public String getPar02() {
		return this.par02;
	}
	
	public void setPar02(String par02) {
		this.par02 = par02;
	}
	
	public String getParv2() {
		return this.parv2;
	}
	
	public void setParv2(String parv2) {
		this.parv2 = parv2;
	}
	
	public String getPar03() {
		return this.par03;
	}
	
	public void setPar03(String par03) {
		this.par03 = par03;
	}
	
	public String getParv3() {
		return this.parv3;
	}
	
	public void setParv3(String parv3) {
		this.parv3 = parv3;
	}
	
	public String getPar04() {
		return this.par04;
	}
	
	public void setPar04(String par04) {
		this.par04 = par04;
	}
	
	public String getParv4() {
		return this.parv4;
	}
	
	public void setParv4(String parv4) {
		this.parv4 = parv4;
	}
	
	public String getPar05() {
		return this.par05;
	}
	
	public void setPar05(String par05) {
		this.par05 = par05;
	}
	
	public String getParv5() {
		return this.parv5;
	}
	
	public void setParv5(String parv5) {
		this.parv5 = parv5;
	}
	
	public String getPar06() {
		return this.par06;
	}
	
	public void setPar06(String par06) {
		this.par06 = par06;
	}
	
	public String getParv6() {
		return this.parv6;
	}
	
	public void setParv6(String parv6) {
		this.parv6 = parv6;
	}
	
	public String getLstarRef1() {
		return this.lstarRef1;
	}
	
	public void setLstarRef1(String lstarRef1) {
		this.lstarRef1 = lstarRef1;
	}
	
	public String getZbz() {
		return this.zbz;
	}
	
	public void setZbz(String zbz) {
		this.zbz = zbz;
	}
	
	public String getUpdkz() {
		return this.updkz;
	}
	
	public void setUpdkz(String updkz) {
		this.updkz = updkz;
	}
}
