package com.huigou.topsun.sap.workcenter.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.sap.workcenter.application.SapWorkCenterApplication;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * SapWorkCenterLogController SAP工作中心控制类
 *
 * @author qinzhenguan
 * @createDate 2024/01/16 14:27
 **/
@RequiredArgsConstructor
@Controller
@ControllerMapping("/sapWorkCenter")
public class SapWorkCenterLogController extends CommonController {

    private final SapWorkCenterApplication centerServer;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/workCenter/";
    }

    public String goWorkCenter() {
        return forward("sapWorkCenter");
    }

    public String findWorkCenter() {
        ArrayList<Map<String, Object>> list = centerServer.findWorkCenter();
        HashMap<Object, Object> map = new HashMap<>(3);
        map.put("Rows", list);
        return toResult(map);
    }

    public String goWorkCenterDetail() {
        SDO sdo = this.getSDO();
        return forward("sapWorkCenterDetail");
    }

    /**
     * description 模拟 SAP 接口 (临时) 能否提供条件查询及分页？
     * @return java.lang.String
     * @author qinzhenguan
     * @createDate 2024/1/17 14:57
     */
    @SkipAuth
    public String queryWorkCenter() throws JsonProcessingException {
        String workCenter = centerServer.queryWorkCenter();
        return success(workCenter);
    }


}