package com.huigou.topsun.sap.workcenter.application.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import com.huigou.topsun.common.CloseableClientHttpRequest;
import com.huigou.topsun.sap.workcenter.domain.SapWorkCenterLog;
import com.huigou.topsun.sap.workcenter.repository.SapWorkCenterRepository;
import com.huigou.topsun.sap.workcenter.application.SapWorkCenterApplication;
import com.huigou.topsun.sap.workcenter.domain.SapWorkCenter;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author YourUserName
 */
@Service
@RequiredArgsConstructor
public class SapWorkCenterApplicationImpl implements SapWorkCenterApplication {

    private final ObjectMapper objectMapper;

    private final SapWorkCenterRepository rep;

    /***
     * description 发送请求到 SAP 系统，获取工作中心数据
     * @return java.util.ArrayList<java.util.Map < java.lang.String, java.lang.Object>>
     * @author qinzhenguan
     * @createDate 2024/1/17 15:44
     */
    @Override
    public ArrayList<Map<String, Object>> findWorkCenter() {
        String execute;
        HashMap<String, Object> param = new HashMap<>(12);
        List<SapWorkCenter> workCenters;
        try {
            execute = execute(param, "http://127.0.0.1:8080/topsun_xt_war/sapWorkCenter/queryWorkCenter.ajax");
            String resultStr = JSONObject.parseObject(execute).get("data").toString();
            workCenters = objectMapper.readValue(resultStr, new TypeReference<List<SapWorkCenter>>() {});
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (workCenters.size() == 0) {
            return null;
        }
        return objectMapper.convertValue(workCenters, new TypeReference<ArrayList<Map<String, Object>>>() {
        });
    }

    /**
     * description 模拟 SAP 接口 (临时)
     * @return java.lang.String
     * @author qinzhenguan
     * @createDate 2024/1/17 14:57
     */
    @Override
    public String queryWorkCenter() throws JsonProcessingException {
        List<SapWorkCenter> list = rep.findAll();
        return list.size() > 0 ? objectMapper.writeValueAsString(list) : "";
    }

    /***
     * description  模拟发送请求到 SAP
     * @param param 请求体 body
     * @param url  请求地址
     * @return java.lang.String
     * @author qinzhenguan
     * @createDate 2024/1/17 17:01
     */
    public String execute(Object param, String url) throws IOException {
        String str = "";
        try {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            requestFactory.setConnectTimeout(5000);
            requestFactory.setReadTimeout(5000);

            URI uri = URI.create(url);
            HttpMethod method = HttpMethod.POST;

            // ------------------------  header  ------------------------
            try (CloseableClientHttpRequest request = new CloseableClientHttpRequest(requestFactory.createRequest(uri, method))) {
                request.addHeader("Content-type", "application/json;charset=utf-8");

                // ------------------------  body  ------------------------
                JSONObject body = new JSONObject();
                try (OutputStream requestBody = request.getBody()) {
                    requestBody.write(body.toString().getBytes());
                }

                // ------------------------  response  ------------------------
                try (ClientHttpResponse response = request.execute();
                     InputStream ist = response.getBody();
                     InputStreamReader istr = new InputStreamReader(ist, StandardCharsets.UTF_8);
                     BufferedReader bfreader = new BufferedReader(istr)) {

                    str = bfreader.readLine();
                    System.out.println(str);
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return str;
    }

}
