package com.huigou.topsun.sap.salesOrder.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.customer.domain.Customer;
import com.huigou.topsun.customer.domain.vo.CustomerVo;
import com.huigou.topsun.sap.salesOrder.domain.SapSalesOrder;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class SapSalesOrderVo implements Serializable {
    /**
     * 销售订单id
     */
    private String salesOrderId;

    /**
     * 销售单号
     */
    private String salesOrderCode;

    /**
     * 订单类型
     */
    private String salesOrderType;

    /**
     * 客户
     */
    private String salesOrderCustomer;

    /**
     * 客户单号
     */
    private String salesOrderCustomerCode;

    /**
     * 下单日期
     */
    private Date salesOrderDate;

    /**
     * 交易币别
     */
    private String salesOrderCurrency;

    /**
     * 交易倍数
     */
    private String salesOrderMultiple;

    /**
     * 款式
     */
    private String salesOrderStyle;

    /**
     * 申购/采购单号
     */
    private String salesOrderProcureCode;

    /**
     * 跟单员
     */
    private String salesOrderMerchandiser;

    /**
     * 备注
     */
    private String salesOrderRemarks;

    /**
     * 创建时间
     */
    private Date salesOrderCreateTime;

    /**
     * 创建人
     */
    private String salesOrderCreator;

    /**
     * 审批时间
     */
    private Date salesOrderApprovalTime;

    /**
     * 审核人
     */
    private String salesOrderReviewer;

    public String getSalesOrderId() {
        return salesOrderId;
    }

    public static SapSalesOrderVo getSapSalesOrderVo(SapSalesOrder sapSalesOrder){
        return JSON.parseObject(JSON.toJSONString(sapSalesOrder), SapSalesOrderVo.class);
    }

    public static SapSalesOrder getSapSalesOrder(SapSalesOrderVo sapSalesOrderVo){
        return JSON.parseObject(JSON.toJSONString(sapSalesOrderVo), SapSalesOrder.class);
    }
}
