package com.huigou.topsun.sap.salesOrder.domain.vo;


import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class SapSalesOrderItemVo implements Serializable {
    /**
     * 销售订单明细id
     */
    private String salesOrderItemId;

    /**
     * 销售订单id
     */
    private String salesOrderId;

    /**
     * 销售项次
     */
    private String salesOrderItemNumber;

    /**
     * 产品
     */
    private String salesOrderItemProduct;

    /**
     * 客户产品编码
     */
    private String salesOrderItemProductCode;

    /**
     * 客户产品名称
     */
    private String salesOrderItemProductName;

    /**
     * 订单量
     */
    private String salesOrderItemProductOrderCount;

    /**
     * loss数
     */
    private String salesOrderItemLossCount;

    /**
     * 单位
     */
    private String salesOrderItemUnit;

    /**
     * 尺码单位
     */
    private String salesOrderItemSizeUnit;

    /**
     * 交货日期
     */
    private Date salesOrderItemDeliveryDate;

    /**
     * 指令号
     */
    private String salesOrderItemInstructionCode;

    /**
     * 型体号
     */
    private String salesOrderItemFormCode;

    /**
     * 配色号
     */
    private String salesOrderItemColorCode;

    /**
     * 产品用途
     */
    private String salesOrderItemUsage;

    /**
     * 段别
     */
    private String salesOrderItemDifference;

    /**
     * 周期
     */
    private String salesOrderItemCycle;

    /**
     * 季度
     */
    private String salesOrderItemQuarter;

    /**
     * 产地
     */
    private String salesOrderItemProducer;

    /**
     * PO号
     */
    private String salesOrderItemPoCode;

    /**
     * WIP号
     */
    private String salesOrderItemWipCode;

    /**
     * 装箱数
     */
    private String salesOrderItemPackingCount;

    /**
     * 销线
     */
    private String salesOrderItemSalesLine;

    /**
     * 产品规格
     */
    private String salesOrderItemSpecifications;

    /**
     * SK编号
     */
    private String salesOrderItemSkCode;

    /**
     * 专利号
     */
    private String salesOrderItemPatentCode;

    /**
     * 材质描述
     */
    private String salesOrderItemMaterialDescription;

    /**
     * 销售订单明细表备注
     */
    private String salesOrderItemRemarks;

    /**
     * 签收人
     */
    private String salesOrderItemSignee;

    /**
     * SHIP TO ID
     */
    private String salesOrderItemShipToId;

    /**
     * 包装方式
     */
    private String salesOrderItemPackingMethod;

    /**
     * 印刷方向
     */
    private String salesOrderItemPrintDirection;

    /**
     * 单价
     */
    private BigDecimal salesOrderItemUnitPrice;

    /**
     * 总金额
     */
    private BigDecimal salesOrderItemTotalAmount;

}
