package com.huigou.topsun.sap.salesOrder.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 销售订单表明细表
 * @TableName sap_sales_order_item
 */
@Table(name="sap_sales_order_item")
@Data
@Entity
public class SapSalesOrderItem implements Serializable {
    /**
     * 销售订单明细id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "sales_order_item_id")
    private String salesOrderItemId;

    /**
     * 销售订单id
     */
    @Column(name = "sales_order_id")
    private String salesOrderId;

    /**
     * 销售项次
     */
    @Column(name = "sales_order_item_number")
    private String salesOrderItemNumber;

    /**
     * 产品
     */
    @Column(name = "sales_order_item_product")
    private String salesOrderItemProduct;

    /**
     * 客户产品编码
     */
    @Column(name = "sales_order_item_product_code")
    private String salesOrderItemProductCode;

    /**
     * 客户产品名称
     */
    @Column(name = "sales_order_item_product_name")
    private String salesOrderItemProductName;

    /**
     * 订单量
     */
    @Column(name = "sales_order_item_product_order_count")
    private String salesOrderItemProductOrderCount;

    /**
     * loss数
     */
    @Column(name = "sales_order_item_loss_count")
    private String salesOrderItemLossCount;

    /**
     * 单位
     */
    @Column(name = "sales_order_item_unit")
    private String salesOrderItemUnit;

    /**
     * 尺码单位
     */
    @Column(name = "sales_order_item_size_unit")
    private String salesOrderItemSizeUnit;

    /**
     * 交货日期
     */
    @Column(name = "sales_order_item_delivery_date")
    private Date salesOrderItemDeliveryDate;

    /**
     * 指令号
     */
    @Column(name = "sales_order_item_instruction_code")
    private String salesOrderItemInstructionCode;

    /**
     * 型体号
     */
    @Column(name = "sales_order_item_form_code")
    private String salesOrderItemFormCode;

    /**
     * 配色号
     */
    @Column(name = "sales_order_item_color_code")
    private String salesOrderItemColorCode;

    /**
     * 产品用途
     */
    @Column(name = "sales_order_item_usage")
    private String salesOrderItemUsage;

    /**
     * 段别
     */
    @Column(name = "sales_order_item_difference")
    private String salesOrderItemDifference;

    /**
     * 周期
     */
    @Column(name = "sales_order_item_cycle")
    private String salesOrderItemCycle;

    /**
     * 季度
     */
    @Column(name = "sales_order_item_quarter")
    private String salesOrderItemQuarter;

    /**
     * 产地
     */
    @Column(name = "sales_order_item_producer")
    private String salesOrderItemProducer;

    /**
     * PO号
     */
    @Column(name = "sales_order_item_PO_code")
    private String salesOrderItemPoCode;

    /**
     * WIP号
     */
    @Column(name = "sales_order_item_WIP_code")
    private String salesOrderItemWipCode;

    /**
     * 装箱数
     */
    @Column(name = "sales_order_item_packing_count")
    private String salesOrderItemPackingCount;

    /**
     * 销线
     */
    @Column(name = "sales_order_item_sales_line")
    private String salesOrderItemSalesLine;

    /**
     * 产品规格
     */
    @Column(name = "sales_order_item_specifications")
    private String salesOrderItemSpecifications;

    /**
     * SK编号
     */
    @Column(name = "sales_order_item_SK_code")
    private String salesOrderItemSkCode;

    /**
     * 专利号
     */
    @Column(name = "sales_order_item_patent_code")
    private String salesOrderItemPatentCode;

    /**
     * 材质描述
     */
    @Column(name = "sales_order_item_material_description")
    private String salesOrderItemMaterialDescription;

    /**
     * 销售订单明细表备注
     */
    @Column(name = "sales_order_item_remarks")
    private String salesOrderItemRemarks;

    /**
     * 签收人
     */
    @Column(name = "sales_order_item_signee")
    private String salesOrderItemSignee;

    /**
     * SHIP TO ID
     */
    @Column(name = "sales_order_item_SHIP_TO_ID")
    private String salesOrderItemShipToId;

    /**
     * 包装方式
     */
    @Column(name = "sales_order_item_packing_method")
    private String salesOrderItemPackingMethod;

    /**
     * 印刷方向
     */
    @Column(name = "sales_order_item_print_direction")
    private String salesOrderItemPrintDirection;

    /**
     * 单价
     */
    @Column(name = "sales_order_item_unit_price")
    private BigDecimal salesOrderItemUnitPrice;

    /**
     * 总金额
     */
    @Column(name = "sales_order_item_total_amount")
    private BigDecimal salesOrderItemTotalAmount;

    private static final long serialVersionUID = 1L;
}