package com.huigou.topsun.sap.salesOrder.controller;

import com.huigou.topsun.sap.salesOrder.application.SapSalesOrderApplication;
import com.huigou.topsun.sap.salesOrder.domain.SapSalesOrder;
import com.huigou.topsun.sap.salesOrder.domain.SapSalesOrderItem;
import com.huigou.topsun.sap.salesOrder.domain.SapSalesOrderOtherInfo;
import com.huigou.topsun.sap.salesOrder.domain.dto.SalesOrderItemDto;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;


@Controller
@ControllerMapping("/sapSalesOrder")
public class SapSalesOrderController extends CommonController {
    @Autowired
    private SapSalesOrderApplication sapSalesOrderApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/salesOrder/";
    }

    public String forwardSalesOrderList() {
        return forward("salesOrderList");
    }
    @SkipAuth
//    @RequestMapping(value = "/json",method = RequestMethod.POST,produces = "application/json;charset=UTF-8")
//    @ResponseBody
//    @RequestBody SalesOrderItemDto salesOrderItemDto
    public String saveSalesOrder() {
        SDO sdo = getUploadSDO();
        SapSalesOrder sapSalesOrder = sdo.toObject(SapSalesOrder.class);
        SapSalesOrderItem sapSalesOrderItem = sdo.toObject(SapSalesOrderItem.class);
        SapSalesOrderOtherInfo sapSalesOrderOtherInfo = sdo.toObject(SapSalesOrderOtherInfo.class);
//        SapSalesOrder sapSalesOrder = new SapSalesOrder();
//        SapSalesOrderItem sapSalesOrderItem = new SapSalesOrderItem();
//        SapSalesOrderOtherInfo sapSalesOrderOtherInfo = new SapSalesOrderOtherInfo();
//        BeanUtils.copyProperties(salesOrderItemDto,sapSalesOrder);
//        BeanUtils.copyProperties(salesOrderItemDto,sapSalesOrderItem);
//        BeanUtils.copyProperties(salesOrderItemDto,sapSalesOrderOtherInfo);
        sapSalesOrderApplication.saveSalesOrder(sapSalesOrder,sapSalesOrderItem,sapSalesOrderOtherInfo);
        return success();
    }


}
