package com.huigou.topsun.sap.purchaseApproval.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 
 * @TableName sap_purchase_approval_item
 */
@Data
public class SapPurchaseApprovalItemVo {

    /**
     * 项目编号（已删除（EBAN-LOEKZ=X）者不传EP；已结清（EBAN-EBAKZ=X）者也不传（结清指已全部转为采购订单））
     */
    private String bnfpo;

    /**
     * 项目类别
     */
    private String pstyp;

    /**
     * 项目类别描述
     */
    private String ptext;

    /**
     * 科目分配类别
     */
    private String knttp;

    /**
     * 科目分配类别描述
     */
    private String knttx;

    /**
     * 物料号 
     */
    private String matnr;

    /**
     * 物料描述
     */
    private String txz01;

    /**
     * 物料组
     */
    private String matkl;

    /**
     * 物料组描述
     */
    private String wgbez;

    /**
     * 采购申请数量
     */
    private BigDecimal menge;

    /**
     * 采购申请计量单位
     */
    private String meins;

    /**
     * 单位描述
     */
    private String msehl;

    /**
     * 要求交货日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date lfdat;

    /**
     * 工厂
     */
    private String werks;

    /**
     * 名称
     */
    private String name1;

    /**
     * 库存地点
     */
    private String lgort;

    /**
     * 库存地点的描述 
     */
    private String lgobe;

    /**
     * 采购组
     */
    private String ekgrp;

    /**
     * 采购组描述
     */
    private String eknam;

    /**
     * 评估价格
     */
    private BigDecimal preis;

    /**
     * 价格单位
     */
    private String peinh;

    /**
     * 币种
     */
    private String waers;

    /**
     * 评估金额
     */
    private BigDecimal rlwrt;

}