package com.huigou.topsun.sap.purchaseApproval.domain;

import javax.persistence.*;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

/**
 * SAP采购申请审批表
 * @TableName sap_purchase_approval
 */
@Table(name="sap_purchase_approval")
@Entity
@Data
public class SapPurchaseApproval extends FlowBillAbstractEntity {

    /**
     * 采购申请号
     */
    @Column(name = "BANFN")
    private String banfn;

    /**
     * 采购申请类型（只传输四种：NB、ZNB1、ZNB2和ZSTR）
     */
    @Column(name = "BSART")
    private String bsart;

    /**
     * 采购申请类型描述
     */
    @Column(name = "BATXT")
    private String batxt;

    private static final long serialVersionUID = 1L;

    @Override
    protected String getCodeRuleId() {
        return "sapPurchaseApproval";
    }
}