package com.huigou.topsun.sap.purchaseApproval.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.purchaseApproval.application.SapPurchaseApprovalApplication;
import com.huigou.topsun.sap.purchaseApproval.domain.SapPurchaseApproval;
import com.huigou.topsun.sap.purchaseApproval.domain.query.SapPurchaseApprovalQueryRequest;
import com.huigou.topsun.sap.purchaseApproval.domain.vo.SapPurchaseApprovalVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/18:58
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchaseApproval")
public class SapPurchaseApprovalController extends CommonController {
    @Resource
    private SapPurchaseApprovalApplication sapPurchaseApprovalApplication;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/purchaseApproval/";
    }

    @SkipAuth
    @RequestMapping( value = "/getSapPurchaseApproval")
    @ResponseBody
    public HashMap<String, Object> getSapPurchaseApproval(@RequestBody SapPurchaseApprovalVo sapPurchaseApprovalVo){
        //SDO sdo = this.getSDO();
        this.sapPurchaseApprovalApplication.saveSapPurchaseApprovalVo(sapPurchaseApprovalVo);
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("Message_Status","S");
        messageMap.put("Message_Text","成功");
        return messageMap;
    }

    public String forwardSapPurchaseApprovalList(){
        return forward("sapPurchaseApprovalList");
    }

    public String slicedSapPurchaseApprovalList(){
        SDO sdo = this.getSDO();
        SapPurchaseApprovalQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseApprovalQueryRequest.class);
        Map<String, Object> map = sapPurchaseApprovalApplication.slicedSapPurchaseApprovalList(queryRequest);
        return toResult(map);
    }

    public String forwardSapPurchaseApprovalDetail(){
        this.putAttribute("processDefinitionKey", SapPurchaseApprovalApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapPurchaseApproval sapPurchase = new SapPurchaseApproval();
        sapPurchase.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapPurchase.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("sapPurchaseApprovalDetail",sapPurchase);
    }

    public String showSapPurchaseApprovalDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapPurchaseApproval sapPurchaseApproval = sapPurchaseApprovalApplication.loadSapPurchaseApproval(id);
        return forward("sapPurchaseApprovalDetail",sapPurchaseApproval);
    }
}
