package com.huigou.topsun.sap.purchaseApproval.application.impl;

import cn.hutool.core.bean.BeanUtil;
import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.context.ThreadLocalUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.purchaseApproval.application.SapPurchaseApprovalApplication;
import com.huigou.topsun.sap.purchaseApproval.application.SapPurchaseApprovalItemApplication;
import com.huigou.topsun.sap.purchaseApproval.domain.SapPurchaseApproval;
import com.huigou.topsun.sap.purchaseApproval.domain.SapPurchaseApprovalItem;
import com.huigou.topsun.sap.purchaseApproval.domain.query.SapPurchaseApprovalQueryRequest;
import com.huigou.topsun.sap.purchaseApproval.domain.vo.SapPurchaseApprovalItemVo;
import com.huigou.topsun.sap.purchaseApproval.domain.vo.SapPurchaseApprovalVo;
import com.huigou.topsun.sap.purchaseApproval.repository.SapPurchaseApprovalRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bmp.operator.OperatorApplication;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.uasp.bpm.ProcessAction;
import com.huigou.uasp.bpm.ProcessStartModel;
import com.huigou.uasp.bpm.engine.application.WorkflowApplication;
import com.huigou.util.ClassHelper;
import com.huigou.util.Constants;
import com.huigou.util.SDO;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/18:59
 * @Description:
 */
@Service("sapPurchaseApprovalApplication")
public class SapPurchaseApprovalApplicationImpl extends FlowBroker implements SapPurchaseApprovalApplication {
    @Resource
    private SapPurchaseApprovalRepository sapPurchaseApprovalRepository;
    @Resource
    private SapPurchaseApprovalItemApplication sapPurchaseApprovalItemApplication;
    @Resource
    private WorkflowApplication workflowApplication;
    @Resource
    private OperatorApplication operatorApplication;

    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        SapPurchaseApproval sapPurchaseApproval = getBizEntity(SapPurchaseApproval.class);
        if (sapPurchaseApproval.isNew()) {
            sapPurchaseApproval.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            sapPurchaseApproval = (SapPurchaseApproval) commonDomainService.loadAndFillinProperties(sapPurchaseApproval);
        }
        sapPurchaseApproval = sapPurchaseApprovalRepository.save(sapPurchaseApproval);
        List<SapPurchaseApprovalItem> sapPurchaseApprovalItems = getBizEntities(SapPurchaseApprovalItem.class, "sapPurchaseItems");
        sapPurchaseApprovalItemApplication.saveSapPurchaseApprovalItems(sapPurchaseApproval.getId(),sapPurchaseApprovalItems);

        //String sapPurchaseVoJson = this.getSapPurchaseVoJson(sapPurchaseApproval);
        return sapPurchaseApproval.getId();
    }



    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        // 返回业务数据给流程实例，
        return ClassHelper.toMap(sapPurchaseApprovalRepository.getOne(bizId));
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        SapPurchaseApproval sapPurchaseApproval = sapPurchaseApprovalRepository.findOne(bizId);
        sapPurchaseApproval.setStatusId(status.getId());
        sapPurchaseApprovalRepository.save(sapPurchaseApproval);
    }

    /**
     * 转换成SAP JSON格式数据
     * @return
     */
    /*public String getSapPurchaseVoJson(SapPurchaseApproval sapPurchase){
        List<SapPurchaseItem> sapPurchaseItemList = this.sapPurchaseApprovalItemApplication.findBySapPurchaseApprovalId(sapPurchase.getId());
        List<SapPurchaseVo> sapPurchaseVoList = new ArrayList<>();
        sapPurchaseItemList.forEach(sapPurchaseItem -> {
            SapPurchaseVo sapPurchaseVo = new SapPurchaseVo();
            BeanUtil.copyProperties(sapPurchaseItem,sapPurchaseVo);
            sapPurchaseVo.setBillCode(sapPurchase.getBillCode());
            sapPurchaseVo.setBsart(sapPurchase.getBsart());
            sapPurchaseVoList.add(sapPurchaseVo);
        });
        ObjectMapper objectMapper = new ObjectMapper();
        String returnJson = null;
        try {
            returnJson = objectMapper.writeValueAsString(sapPurchaseVoList);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return returnJson;
    }*/

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        SapPurchaseApproval sapPurchaseApproval = sapPurchaseApprovalRepository.findOne(bizId);
        sapPurchaseApproval.setStatusId(BizBillStatus.ABORTED.getId());
        sapPurchaseApprovalRepository.save(sapPurchaseApproval);
    }

    /**
     * @param delegateTask
     * @param destActivityId 回退到的目标节点id
     */
    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            SapPurchaseApproval sapPurchaseApproval = sapPurchaseApprovalRepository.findOne(bizId);
            sapPurchaseApproval.setStatusId(BizBillStatus.APPLYING.getId());
            sapPurchaseApprovalRepository.save(sapPurchaseApproval);
        }
    }

    @Override
    public Map<String, Object> slicedSapPurchaseApprovalList(SapPurchaseApprovalQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapPurchaseApprovalList");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        queryModel.putDictionary("status", BizBillStatus.getMap());
        return this.sqlExecutorDao.executeSlicedQuery(queryModel);
    }

    @Override
    public SapPurchaseApproval loadSapPurchaseApproval(String id) {
        return sapPurchaseApprovalRepository.findOne(id);
    }

    @Override
    @Transactional
    public void saveSapPurchaseApprovalVo(SapPurchaseApprovalVo sapPurchaseApprovalVo) {
        SapPurchaseApproval sapPurchaseApproval = new SapPurchaseApproval();
        BeanUtil.copyProperties(sapPurchaseApprovalVo,sapPurchaseApproval);
        //初始化用户信息
        String createdById = "5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0";
        Operator operator = operatorApplication.createOperatorByPersonMemberId(createdById);
        sapPurchaseApproval.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));

        Map<String, Object> formData = BeanUtil.beanToMap(sapPurchaseApproval);
        String bizId = this.startProcessInstance(SapPurchaseApprovalApplication.PROCESS_DEFINITION_KEY, formData);
        sapPurchaseApproval.setId(bizId);
        sapPurchaseApproval = this.sapPurchaseApprovalRepository.save(sapPurchaseApproval);

        List<SapPurchaseApprovalItemVo> approvalItemVoList = sapPurchaseApprovalVo.getItemVos();
        List<SapPurchaseApprovalItem> sapPurchaseApprovalItems =  new ArrayList<>();
        approvalItemVoList.forEach(approvalItemVo->{
            SapPurchaseApprovalItem sapPurchaseApprovalItem = new SapPurchaseApprovalItem();
            BeanUtil.copyProperties(approvalItemVo,sapPurchaseApprovalItem);
            sapPurchaseApprovalItems.add(sapPurchaseApprovalItem);
        });
        sapPurchaseApprovalItemApplication.saveSapPurchaseApprovalItems(sapPurchaseApproval.getId(),sapPurchaseApprovalItems);
    }

    public String startProcessInstance(String processDefinitionKey,Map<String, Object> formData){
        Map<String, Object> variables = new HashMap();
        SDO localSdo = this.buildSDO(formData);
        ThreadLocalUtil.putVariable(Constants.SDO, localSdo);
        variables.put("startModel", ProcessStartModel.MANUAL.getId());
        Operator operator = localSdo.getOperator();
        variables.put("executorFullId", operator.getFullId());
        variables.put("executorFullName", operator.getFullName());
        ThreadLocalUtil.putOperator(operator);
        ThreadLocalUtil.putVariable("client.ip", "127.0.0.1");
        ProcessInstance processInstance = this.workflowApplication.startProcessInstanceByKey(processDefinitionKey, variables);
        String businessKey = processInstance.getBusinessKey();
        return businessKey;
    }

    private SDO buildSDO(Map<String, Object> formData) {
        //String createdById = (String) formData.get("createdById");
        //暂定管理员id
        String createdById = "5EEB2DC861694A65933CB4CE9A8D870A@C18E23AAAA6940E09DF7C122332C51E0";
        Operator operator = operatorApplication.createOperatorByPersonMemberId(createdById);
        SDO localSdo = new SDO();
        // 将业务数据传递给工作流
        formData.forEach(localSdo::putProperty);
        // 将业务流程信息传递给工作流
        localSdo.putProperty("processAction", ProcessAction.SAVE);
        localSdo.putProperty("procUnitId", "Apply");
        localSdo.setOperator(operator);
        return localSdo;
    }
}
