package com.huigou.topsun.sap.purchase.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import cn.hutool.core.lang.Dict;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

/**
 * SAP采购申请项次
 * @TableName sap_purchase_item
 */
@Table(name="sap_purchase_item")
@Entity
@Data
public class SapPurchaseItem extends AbstractEntity {

    /**
     * SAP采购申请id
     */
    @Column(name = "SAP_PURCHASE_ID")
    private String sapPurchaseId;

    /**
     * 申购项次号
     */
    @Column(name = "BNFPO")
    private Integer bnfpo;

    /**
     * 项次类别
     */
    @Column(name = "PSTYP")
    private String pstyp;

    /**
     * 科目分配类别
     */
    @Column(name = "KNTTP")
    private String knttp;

    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 工厂名称
     */
    @Column(name = "NAME1")
    private String name1;

    /**
     * 库存地点
     */
    @Column(name = "LGORT")
    private String lgort;

    /**
     * 库存地点名称
     */
    @Column(name = "LGOBE")
    private String lgobe;

    /**
     * 物料编号
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * 短文本
     */
    @Column(name = "TXZ01")
    private String txz01;

    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;

    /**
     * 申购数量
     */
    @Column(name = "MENGE")
    private BigDecimal menge;

    /**
     * 申购数量单位
     */
    @Column(name = "MEINS")
    private String meins;

    /**
     * 采购组
     */
    @Column(name = "EKGRP")
    private String ekgrp;

    /**
     * 申请日期
     */
    @Column(name = "BADAT")
    private Date badat;

    /**
     * 创建日期
     */
    @Column(name = "ERDAT")
    private Date erdat;

    /**
     * 批准日期
     */
    @Column(name = "FRGDT")
    private Date frgdt;

    /**
     * 要求交货日期
     */
    @Column(name = "LFDAT")
    private Date lfdat;

    /**
     * 服务主数据编号
     */
    @Column(name = "SRVPOS")
    private String srvpos;

    /**
     * 服务短文本
     */
    @Column(name = "KTEXT1")
    private String ktext1;

    /**
     * 服务条目数量
     */
    @Column(name = "ESLL_MENGE")
    private BigDecimal esllMenge;

    /**
     * 服务计量单位
     */
    @Column(name = "ESLL_MEINS")
    private String esllMeins;

    /**
     * 定价基数
     */
    @Column(name = "PEINH")
    private Integer peinh;

    /**
     * 服务预估单价
     */
    @Column(name = "BRTWR")
    private BigDecimal brtwr;

    /**
     * 服务预估金额
     */
    @Column(name = "NETWR")
    private BigDecimal netwr;

    /**
     * 创建者
     */
    @Column(name = "ERNAM")
    private String ernam;

    /**
     * 申请人
     */
    @Column(name = "AFNAM")
    private String afnam;

    /**
     * 评估价格
     */
    @Column(name = "PREIS")
    private BigDecimal preis;

    /**
     * 价格基数
     */
    @Column(name = "EBAN_PEINH")
    private Integer ebanPeinh;

    /**
     * 币种
     */
    @Column(name = "WAERS")
    private String waers;

    /**
     * 评估金额
     */
    @Column(name = "EBAN_NETWR")
    private BigDecimal ebanNetwr;

    /**
     * 会计分配序号
     */
    @Column(name = "ZEBKN")
    private Integer zebkn;

    /**
     * 多重科目分配
     */
    @Column(name = "VRTKZ")
    private String vrtkz;

    /**
     * 部分发票
     */
    @Column(name = "TWRKZ")
    private String twrkz;

    /**
     * PR分解数量
     */
    @Column(name = "EKBN_MENGE")
    private Long ekbnMenge;

    /**
     * 总账科目
     */
    @Column(name = "SAKTO")
    private String sakto;

    /**
     * 成本中心
     */
    @Column(name = "KOSTL")
    private String kostl;

    /**
     * 订单号
     */
    @Column(name = "AUFNR")
    private String aufnr;

    /**
     * 主资产号
     */
    @Column(name = "ANLN1")
    private String anln1;

    /**
     * 子资产号
     */
    @Column(name = "ANLN2")
    private String anln2;

    /**
     * 审批处理状态
     */
    @Column(name = "BANPR")
    private String banpr;

    private static final long serialVersionUID = 1L;
}