package com.huigou.topsun.sap.nonProdApply.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 非产品/非本成品类物料主数据维护申请基础表
 * @TableName non_prod_apply_base_info
 */
@Table(name="sap_non_prod_apply_base_info")
@Data
@Entity
public class NonProdApplyBaseInfo extends FlowBillAbstractEntity {

    /**
     * 维护类型
     */
    @Column(name = "maintenance_type")
    private String maintenanceType;

    /**
     * 批准状态
     */
    @Column(name = "approval_status")
    private String approvalStatus;

    /**
     * 批准人
     */
    private String approver;

    /**
     * 批准日期
     */
    @Column(name = "approval_date")
    private Date approvalDate;

    /**
     * 通用品名
     */
    @Column(name = "generic_name")
    private String genericName;

    /**
     * 适用标准
     */
    @Column(name = "applicable_standard")
    private String applicableStandard;

    /**
     * 基本计量单位
     */
    @Column(name = "base_unit")
    private String baseUnit;

    /**
     * 规格
     */
    private String specifications;

    /**
     * 材质
     */
    private String material;

    /**
     * 版式
     */
    private String design;

    /**
     * 尺码
     */
    private String size;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 用途
     */
    @Column(name = "material_usage")
    private String materialUsage;

    /**
     * 物品属性
     */
    @Column(name = "item_attributes")
    private String itemAttributes;

    /**
     * 业务用途
     */
    @Column(name = "business_usage")
    private String businessUsage;

    /**
     * 文本说明
     */
    @Column(name = "text_description")
    private String textDescription;


    @Override
    protected String getCodeRuleId() {
        return "sapNonProdApply";
    }
}