package com.huigou.topsun.sap.nonProdApply.controller;


import com.huigou.cache.DictUtil;
import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.base.bsnMessage.appliction.BsnMessageApplication;
import com.huigou.topsun.base.bsnMessage.domain.ActiveStatus;
import com.huigou.topsun.base.bsnMessage.domain.BsnMessage;
import com.huigou.topsun.proofing.domain.workInstructionApply.model.WorkInstructionApply;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyApplication;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyDeptApplication;
import com.huigou.topsun.sap.nonProdApply.domain.NonProdApplyBaseInfo;
import com.huigou.topsun.sap.nonProdApply.domain.SapNonProdApplyDept;
import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bmp.common.easysearch.EasySearch;
import com.huigou.uasp.bmp.common.easysearch.domain.model.EasySearchParse;
import com.huigou.uasp.bmp.common.easysearch.domain.model.QuerySchemeField;
import com.huigou.uasp.bmp.opm.application.MemEasySearcher;
import com.huigou.uasp.bmp.opm.application.impl.MemEasySearcherImpl;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;

import java.util.*;

@Controller
@ControllerMapping("/sapNonProdApplyNext")
public class NonProdApplyNextController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/sap/nonProdApply/";
    }
    @Autowired
    NonProdApplyApplication nonProdApplyApplication;
    @Autowired
    NonProdApplyDeptApplication nonProdApplyDeptApplication;
    @Autowired
    BsnMessageApplication bsnMessageApplication;



    public String forwardNonProdApplyNext(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        this.putAttribute("active", ActiveStatus.UNFINISHED.getValue() );//定义流程环节的id
        NonProdApplyBaseInfo nonProdApplyBaseInfo = nonProdApplyApplication.loadNonProdApplyBaseInfoById(id);
        return forward("nonProdApplyNext",nonProdApplyBaseInfo);
    }

    //部门相关
    public String slicedDeptList(){
        SDO sdo = this.getSDO();
        String septString = sdo.getString("dept");
//        String applyDeptId = sdo.getString("applyDeptId");
//        List<BsnMessage> bsnMessageAll = bsnMessageApplication.getBsnMessageByBusinessId(applyDeptId);
        List<String> deptList = Arrays.asList(septString.split(","));
        Map<String, String> serviceusage = DictUtil.getDictionary("serviceusage");
         // 用于存储结果的字典
        Map<String, List<HashMap<String,String>>> map = new HashMap<>(); // 用于存储结果的字典
        List<HashMap<String, String>> list = new ArrayList<>();
        for (String key : deptList) {
            HashMap<String, String> resultMap = new HashMap<>();
            String value = serviceusage.get(key);
            resultMap.put("deptCode",key);
            resultMap.put("deptName", value);
            list.add(resultMap);
        }
        map.put("Rows",list);
        return toResult(map);
    }

    /**
     * 添加
     */
    public String saveSapNonProdApplyDept(){
        SDO sdo = this.getSDO();
        Map<String, Object> map = nonProdApplyDeptApplication.saveSapNonProdApplyDept(sdo);
        return toResult(map);
    }


    /**
     * 分发表单
     */
    public String distributeSapNonProdApplyDept(){
        SDO sdo = this.getSDO();
        nonProdApplyDeptApplication.distributeSapNonProdApplyDept(sdo);
        return success();
    }

    /**
     * 填写收到的任务表单
     * @return
     */
    public String fillInNonProdApplyDept(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        String active = sdo.getString("active");
        String taskSponsor = sdo.getString("taskSponsor");
        Map<String, String> map = DictUtil.getDictionary("serviceusage");
        this.putAttribute("bu",map);
        this.putAttribute("isReadOnly","false");
        this.putAttribute("active",active);
        this.putAttribute("taskSponsor",taskSponsor);
        SapNonProdApplyDept nonProdApplyDept = nonProdApplyDeptApplication.getNonProdApplyDeptById(id);
        return forward("nonProdApplyNext",nonProdApplyDept);
    }


//    @EasySearch(queryName = "userNameSelect")
//    public Map<String, Object> queryResourceNameGroup(SDO sdo){
//        Integer intPage = sdo.getInteger("intPage", 1);
//        Integer pageSize = sdo.getInteger("pageSize",10);
//        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
//        List<QuerySchemeField> fields =
//                Arrays.asList(new QuerySchemeField("id", "id", "hidden"),
//                        new QuerySchemeField("资源名称", "gxmc", "string", 200L),
//                        new QuerySchemeField("资源编码", "gxbm", "string", 100L),
//                        new QuerySchemeField("单位", "dw", "string", 100L),
//                        new QuerySchemeField("用量", "yl", "string", 100L),
//                        new QuerySchemeField("工作中心", "gzzx", "string", 100L));
//        EasySearchParse easySearchParse = new EasySearchParse();
//        easySearchParse.setFields(fields);
//        easySearchParse.setWidth(450L);
//        String processType = sdo.getString("paramValue");
////        List<Map<String, Object>> mapList = resourceFiledService.getResourceFieldValueListByProcess(processType);
//        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
//        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
//        return model;
//        return null;
//    }


    public void rejectNonProdApplyDept(){
        SDO sdo = this.getSDO();
        String septString = sdo.getString("dept");
        //需要被驳回的部门
        List<String> deptList = Arrays.asList(septString.split(","));

    }
}


