package com.huigou.topsun.sap.nonProdApply.application.impl;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.context.Operator;
import com.huigou.topsun.base.bsnMessage.domain.ActiveStatus;
import com.huigou.topsun.base.bsnMessage.domain.BsnMessage;
import com.huigou.topsun.base.bsnMessage.repository.BsnMessageRepository;
import com.huigou.topsun.proofing.domain.proofingApply.model.ProofingApplyProcess;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyDeptApplication;

import com.huigou.topsun.sap.nonProdApply.domain.SapNonProdApplyDept;
import com.huigou.topsun.sap.nonProdApply.repository.NonProdApplyDeptRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;

import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class NonProdApplyDeptApplicationImpl extends BaseApplication implements NonProdApplyDeptApplication {

    @Autowired
    NonProdApplyDeptRepository nonProdApplyDeptRepository;
    @Autowired
    BsnMessageRepository bsnMessageRepository;

    @Override
    public Map<String,Object> saveSapNonProdApplyDept(SDO sdo){
        Map<String,Object> map = new HashMap<>();
        SapNonProdApplyDept nonProdApplyDept = sdo.toObject(SapNonProdApplyDept.class);
        nonProdApplyDept = nonProdApplyDeptRepository.save(nonProdApplyDept);

        //获取分发的部门与人员信息
        ObjectMapper objectMapper = new ObjectMapper();
        String deptStaffJSON = sdo.getString("deptStaff");
        List<Map<String, String>> deptStaffList = null;
        try {
            deptStaffList = objectMapper.readValue(deptStaffJSON, new TypeReference<List<Map<String, String>>>() {});
        } catch (JsonProcessingException e) {
            throw new RuntimeException("JSON转换失败："+e);
        }

        //封装分发数据
        List<BsnMessage> bsnMessageList = new ArrayList<>();
        for (Map<String, String> stringMap : deptStaffList) {
            BsnMessage bsnMessage = new BsnMessage();
            String userCode = stringMap.get("userCode");
            String deptName = stringMap.get("deptName");
            String deptCode = stringMap.get("deptCode");
            bsnMessage.setTaskSponsor(this.getOperator().getUserId());
            bsnMessage.setListners(userCode);
            bsnMessage.setBusinessCode(deptCode);
            bsnMessage.setActive(ActiveStatus.SAVED.getValue());
            bsnMessage.setCreateDate(new Date());
            bsnMessage.setTitle("非产品/非本成品类物料");
            bsnMessage.setTaskDescribe(deptName+"部门数据维护");
            bsnMessage.setExecutorUrl("sapNonProdApplyNext/fillInNonProdApplyDept.do");
            bsnMessage.setBusinessId(nonProdApplyDept.getApplyDeptId());
            bsnMessageList.add(bsnMessage);
        }
        bsnMessageRepository.save(bsnMessageList);
        map.put("applyDeptId",nonProdApplyDept.getApplyDeptId());
        return map;
    }

    @Override
    public void distributeSapNonProdApplyDept(SDO sdo) {
        //将状态为保存为分发的全部修改为分发未完成
        Map<String, Object> map = this.saveSapNonProdApplyDept(sdo);
        List<BsnMessage> nonProdApplyDeptList = bsnMessageRepository.findAllByBusinessId((String) map.get("applyDeptId"));
        nonProdApplyDeptList.forEach(item->item.setActive(ActiveStatus.UNFINISHED.getValue()));
        bsnMessageRepository.save(nonProdApplyDeptList);
    }

    @Override
    public SapNonProdApplyDept getNonProdApplyDeptById(String id) {
        return nonProdApplyDeptRepository.findOne(id);
    }


    @Override
    public void rejectNonProdApplyDept(SDO sdo) {
        String septString = sdo.getString("dept");
        //需要被驳回的部门
        List<String> deptList = Arrays.asList(septString.split(","));
        String bdid = sdo.getString("表单的id");
        //更改状态此对象为驳回状态
        SapNonProdApplyDept one = nonProdApplyDeptRepository.findOne(bdid);
        one.setStatus(ActiveStatus.REJECTED.getValue());
        nonProdApplyDeptRepository.save(one);
        //获取此条数据的相关部门信息
        List<BsnMessage> allByBusinessId = bsnMessageRepository.findAllByBusinessId(bdid);
    }
}
