package com.huigou.topsun.sap.nonProdApply.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyApplication;
import com.huigou.topsun.sap.nonProdApply.domain.NonProdApplyBaseInfo;
import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.topsun.sap.nonProdApply.repository.NonProdApplyBaseInfoRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;

import lombok.SneakyThrows;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@Service("nonProdApplyApplication")
public class NonProdApplyApplicationImpl  extends FlowBroker implements NonProdApplyApplication {
    @Autowired
    NonProdApplyBaseInfoRepository nonProdApplyBaseInfoRepository;


    @SneakyThrows
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();

        NonProdApplyBaseInfo nonProdApplyBaseInfo = getBizEntity(NonProdApplyBaseInfo.class);
        if (nonProdApplyBaseInfo.isNew()) {
            nonProdApplyBaseInfo.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            nonProdApplyBaseInfo = (NonProdApplyBaseInfo) commonDomainService.loadAndFillinProperties(nonProdApplyBaseInfo);
        }
        nonProdApplyBaseInfo = nonProdApplyBaseInfoRepository.save(nonProdApplyBaseInfo);

        return nonProdApplyBaseInfo.getId();
    }


    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        // 返回业务数据给流程实例，
        return ClassHelper.toMap(nonProdApplyBaseInfoRepository.getOne(bizId));
    }


    /**
     * 流程实例结束
     *
     * @param delegateExecution
     */
    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        NonProdApplyBaseInfo nonProdApplyBaseInfo = nonProdApplyBaseInfoRepository.findOne(bizId);
        nonProdApplyBaseInfo.setStatusId(status.getId());
        nonProdApplyBaseInfoRepository.save(nonProdApplyBaseInfo);

    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        NonProdApplyBaseInfo nonProdApplyBaseInfo = nonProdApplyBaseInfoRepository.findOne(bizId);
        nonProdApplyBaseInfo.setStatusId(BizBillStatus.ABORTED.getId());
        nonProdApplyBaseInfoRepository.save(nonProdApplyBaseInfo);
    }

    /**
     * @param delegateTask
     * @param destActivityId 回退到的目标节点id
     */
    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            NonProdApplyBaseInfo nonProdApplyBaseInfo = nonProdApplyBaseInfoRepository.findOne(bizId);
            nonProdApplyBaseInfo.setStatusId(BizBillStatus.APPLYING.getId());
            nonProdApplyBaseInfoRepository.save(nonProdApplyBaseInfo);
        }
    }

    @Override
    public NonProdApplyBaseInfo loadNonProdApplyBaseInfoById(String id) {
        return nonProdApplyBaseInfoRepository.findOne(id);
    }

    @Override
    public Map<String, Object> slicedNonProdApplyBaseInfoQuery(NonProdApplyBaseInfoQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedNonProdApplyBaseInfoQuery");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, query);
        model.putDictionary("maintenanceType", DictUtil.getDictionary("maintainType"));
        model.putDictionary("baseUnit", DictUtil.getDictionary("measuringUnit"));
        model.putDictionary("itemAttributes", DictUtil.getDictionary("suppliesType"));
        model.putDictionary("businessUsage", DictUtil.getDictionary("serviceusage"));
        model.putDictionary("status", DictUtil.getDictionary("bizBillStatus"));
        return this.sqlExecutorDao.executeSlicedQuery(model);

    }


    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void deleteNonProdApplyBaseInfoById(String id) {
        nonProdApplyBaseInfoRepository.delete(id);

    }

    @Override
    @Transactional
    public void deleteNonProdApplyBaseInfoByIds(List<String> ids) {
        ids.forEach(this::deleteNonProdApplyBaseInfoById);
    }


}