package com.huigou.topsun.sap.material.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.sap.material.application.MaterialApplication;
import com.huigou.topsun.sap.material.domain.Material;
import com.huigou.topsun.sap.material.domain.query.MaterialQueryRequest;
import com.huigou.topsun.sap.material.repository.MaterialRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/14/16:25
 * @Description:
 */
@Service("materialApplication")
public class MaterialApplicationImpl extends FlowBroker implements MaterialApplication {
    
    @Resource
    private MaterialRepository materialRepository;

    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        Material material = getBizEntity(Material.class);
        if (material.isNew()) {
            material.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            material = (Material) commonDomainService.loadAndFillinProperties(material);
        }
        material = materialRepository.save(material);
        return material.getId();
    }


    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        // 返回业务数据给流程实例，
        return ClassHelper.toMap(materialRepository.getOne(bizId));
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        Material material = materialRepository.findOne(bizId);
        material.setStatusId(status.getId());
        materialRepository.save(material);
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        Material material = materialRepository.findOne(bizId);
        material.setStatusId(BizBillStatus.ABORTED.getId());
        materialRepository.save(material);
    }

    /**
     * @param delegateTask
     * @param destActivityId 回退到的目标节点id
     */
    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            Material material = materialRepository.findOne(bizId);
            material.setStatusId(BizBillStatus.APPLYING.getId());
            materialRepository.save(material);
        }
    }

    @Override
    public Map<String, Object> slicedMaterialList(MaterialQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedQuery");
        return this.sqlExecutorDao.executeSlicedQuery(queryDescriptor,queryRequest);
    }
}
