package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * SAP固定资产主数据
 *
 * @TableName sap_fixed_assets
 */
@Table(name = "sap_fixed_assets")
@Entity
public class SapFixedAssets extends FlowBillAbstractEntity {
    /**
     * BPM单号
     */
    @Column(name = "zbpmn")
    private String zbpmn;

    /**
     * 创建标识
     * 用于标识数据是新增或修改，1为新增，2为修改。（必填）
     */
    @Column(name = "zflg")
    private Integer zflg;

    /**
     * 主资产号
     * ;资产编号内部生成，当创建标识为2，即修改时，主资产号为必输。
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 资产分类
     * 当创建标识为1，即创建时，资产分类必输。
     */
    @Column(name = "anlkl")
    private String anlkl;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 文本（必填）
     */
    @Column(name = "txt50")
    private String txt50;

    /**
     * 存货号；存放地点
     */
    @Column(name = "invnr")
    private String invnr;

    /**
     * 数量
     */
    @Column(name = "menge")
    private BigDecimal menge;

    /**
     * 基本计量单位
     */
    @Column(name = "meins")
    private String meins;

    /**
     * 成本中心（必填）
     */
    @Column(name = "kostl")
    private String kostl;

    /**
     * 责任成本中心
     */
    @Column(name = "kostlv")
    private String kostlv;

    private static final long serialVersionUID = 1L;
    /**
     * ***********返回接收数据*****************
     */
    /**
     * 消息类型
     */
    @Column(name = "MSGTY")
    private String MSGTY;
    /**
     * 消息文本
     */
    @Column(name = "MSGTX")
    private String MSGTX;

    @Override
    protected String getCodeRuleId() {
        return "sapFixedAssets";
    }

    public SapFixedAssets() {
    }

    public SapFixedAssets(String zbpmn, Integer zflg, String anln1, String anlkl, String bukrs, String txt50, String invnr, BigDecimal menge, String meins, String kostl, String kostlv) {
        this.zbpmn = zbpmn;
        this.zflg = zflg;
        this.anln1 = anln1;
        this.anlkl = anlkl;
        this.bukrs = bukrs;
        this.txt50 = txt50;
        this.invnr = invnr;
        this.menge = menge;
        this.meins = meins;
        this.kostl = kostl;
        this.kostlv = kostlv;
    }

    public SapFixedAssets(String MSGTY, String MSGTX) {
        this.MSGTY = MSGTY;
        this.MSGTX = MSGTX;
    }

    public String getZbpmn() {
        return zbpmn;
    }

    public void setZbpmn(String zbpmn) {
        this.zbpmn = zbpmn;
    }

    public Integer getZflg() {
        return zflg;
    }

    public void setZflg(Integer zflg) {
        this.zflg = zflg;
    }

    public String getAnln1() {
        return anln1;
    }

    public void setAnln1(String anln1) {
        this.anln1 = anln1;
    }

    public String getAnlkl() {
        return anlkl;
    }

    public void setAnlkl(String anlkl) {
        this.anlkl = anlkl;
    }

    public String getBukrs() {
        return bukrs;
    }

    public void setBukrs(String bukrs) {
        this.bukrs = bukrs;
    }

    public String getTxt50() {
        return txt50;
    }

    public void setTxt50(String txt50) {
        this.txt50 = txt50;
    }

    public String getInvnr() {
        return invnr;
    }

    public void setInvnr(String invnr) {
        this.invnr = invnr;
    }

    public BigDecimal getMenge() {
        return menge;
    }

    public void setMenge(BigDecimal menge) {
        this.menge = menge;
    }

    public String getMeins() {
        return meins;
    }

    public void setMeins(String meins) {
        this.meins = meins;
    }

    public String getKostl() {
        return kostl;
    }

    public void setKostl(String kostl) {
        this.kostl = kostl;
    }

    public String getKostlv() {
        return kostlv;
    }

    public void setKostlv(String kostlv) {
        this.kostlv = kostlv;
    }

    public String getMSGTY() {
        return MSGTY;
    }

    public void setMSGTY(String MSGTY) {
        this.MSGTY = MSGTY;
    }

    public String getMSGTX() {
        return MSGTX;
    }

    public void setMSGTX(String MSGTX) {
        this.MSGTX = MSGTX;
    }
}