package com.huigou.topsun.sap.dictionary.application.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huigou.cache.SystemCache;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.sap.dictionary.application.SapDictionaryApplication;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/11:24
 * @Description:
 */
@Service
public class SapDictionaryApplicationImpl implements SapDictionaryApplication {
    @Resource
    private HttpClient httpClient;

    @Override
    public List<Map<String,Object>> getSapDictionary(String fieldName) {
        String url = SystemCache.getParameter("sap.service.dictionary.url", String.class);
        Map<String,Object> map = new HashMap<>();
        map.put("FIELDNAME",fieldName);
        String execute = null;
        try {
            execute = httpClient.execute(map, url);
        } catch (IOException e) {
            throw new RuntimeException(String.format("查询“%s数据字典出错”。", fieldName));
        }
        List<Map<String,Object>> mapList = (List<Map<String,Object>>) JSONArray.parse(execute);
        return mapList;
    }
}
