package com.huigou.topsun.sap.costReimbursement.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 
 * @TableName sap_cost_reimbursement_detail
 */
@Table(name="sap_cost_reimbursement_detail")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class SapCostReimbursementDetail implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "reimbursement_detail_id")
    private String reimbursementDetailId;

    /**
     *
     */
    @Column(name = "reimbursement_base_info_id")
    private String reimbursementBaseInfoId;

    /**
     * BP标识
     */
    @Column(name = "ZEP_BPTYPE")
    private String zepBptype;

    /**
     * BP标识描述
     */
    @Column(name = "ZEP_BPTYPENAME")
    private String zepBptypename;

    /**
     * BP
     */
    @Column(name = "PARTNER")
    private String partner;

    /**
     * BP银行账号
     */
    @Column(name = "BANKN")
    private String bankn;

    /**
     * BP账号名称
     */
    @Column(name = "KOINH")
    private String koinh;

    /**
     * BP联行号
     */
    @Column(name = "BANKL")
    private String bankl;

    /**
     * SWIFT/BIC
     */
    @Column(name = "SWIFT")
    private String swift;

    /**
     * BP联行号名称
     */
    @Column(name = "BANKA")
    private String banka;

    /**
     * EP流程子序号
     */
    @Column(name = "ZEP_ITEMNO")
    private String zepItemno;

    /**
     * 计划内外付款标识
     */
    @Column(name = "ZEP_PLAN")
    private String zepPlan;

    /**
     * 计划内外标识名称
     */
    @Column(name = "ZEP_PLANNAME")
    private String zepPlanname;

    /**
     * 费用类型代码
     */
    @Column(name = "ZEP_EXTYPE")
    private String zepExtype;

    /**
     * 费用类型名称
     */
    @Column(name = "ZEP_EXTYPENAME")
    private String zepExtypename;

    /**
     * 费用会计科目
     */
    @Column(name = "HKONT")
    private String hkont;

    /**
     * 总账科目描述
     */
    @Column(name = "TXT50")
    private String txt50;

    /**
     * 计划付款日期
     */
    @Column(name = "ZEP_FPLDATE")
    private Date zepFpldate;

    /**
     * 成本中心
     */
    @Column(name = "KOSTL")
    private String kostl;

    /**
     * 成本中心名称
     */
    @Column(name = "KTEXT1")
    private String ktext1;

    /**
     * 内部订单
     */
    @Column(name = "AUFNR")
    private String aufnr;

    /**
     * 内部订单描述
     */
    @Column(name = "KTEXT")
    private String ktext;

    /**
     * 币别
     */
    @Column(name = "WAERS")
    private String waers;

    /**
     * 汇率
     */
    @Column(name = "KURSF")
    private BigDecimal kursf;

    /**
     * 不含税金额（本位币）
     */
    @Column(name = "NETWR1")
    private BigDecimal netwr1;

    /**
     * 税额（本位币）
     */
    @Column(name = "KWETR1")
    private BigDecimal kwetr1;

    /**
     * 含税金额（本位币）
     */
    @Column(name = "KZWI11")
    private BigDecimal kzwi11;

    /**
     * 税码
     */
    @Column(name = "MWSKZ")
    private String mwskz;

    /**
     * 不含税金额
     */
    @Column(name = "NETWR")
    private BigDecimal netwr;

    /**
     * 税额
     */
    @Column(name = "KWETR")
    private BigDecimal kwetr;

    /**
     * 含税金额
     */
    @Column(name = "KZWI1")
    private BigDecimal kzwi1;

    /**
     * 不含税金额（审批-本位币）
     */
    @Column(name = "ZEP_PDAMOUNT")
    private BigDecimal zepPdamount;

    /**
     * 税额（审批-本位币）
     */
    @Column(name = "ZEP_PDTAX")
    private BigDecimal zepPdtax;

    /**
     * 含税金额（审批-本位币）
     */
    @Column(name = "ZEP_PTDAMOUNT")
    private BigDecimal zepPtdamount;

    /**
     * 不含税金额（审批）
     */
    @Column(name = "ZEP_PDAMOUNT1")
    private BigDecimal zepPdamount1;

    /**
     * 税额（审批）
     */
    @Column(name = "ZEP_PDTAX1")
    private BigDecimal zepPdtax1;

    /**
     * 含税金额（审批）
     */
    @Column(name = "ZEP_PTDAMOUNT1")
    private BigDecimal zepPtdamount1;

    /**
     * 付款方式代码
     */
    @Column(name = "ZLSCH")
    private String zlsch;

    /**
     * 付款方式名称
     */
    @Column(name = "ZLSCH_TEXT1")
    private String zlschText1;

    /**
     * 是否付款
     */
    @Column(name = "ZEP_PAY")
    private String zepPay;

    /**
     * 直联付款标识
     */
    @Column(name = "ZEP_BANK")
    private String zepBank;

    /**
     * 记账凭证编号
     */
    @Column(name = "BELNR")
    private String belnr;

    /**
     * 记账凭证财年
     */
    @Column(name = "GJAHR")
    private String gjahr;

    /**
     * 记账过账日期
     */
    @Column(name = "BUDAT")
    private Date budat;

    /**
     * 记账凭证日期
     */
    @Column(name = "BLDAT")
    private Date bldat;

    /**
     * 付款凭证编号
     */
    @Column(name = "BELNR1")
    private String belnr1;

    /**
     * 付款凭证财年
     */
    @Column(name = "GJAHR1")
    private String gjahr1;

    /**
     * 付款过账日期
     */
    @Column(name = "BUDAT1")
    private Date budat1;

    /**
     * 付款凭证日期
     */
    @Column(name = "BLDAT1")
    private Date bldat1;

    /**
     * 付款状态
     */
    @Column(name = "ZPAY_STAUS")
    private String zpayStaus;

    /**
     * 原因代码
     */
    @Column(name = "RSTGR")
    private String rstgr;

    /**
     * 付款附言
     */
    @Column(name = "ZEP_TXT1")
    private String zepTxt1;

    /**
     * 付款银行账号
     */
    @Column(name = "BANKN1")
    private String bankn1;

    /**
     * 付款银行账号名称
     */
    @Column(name = "ZT012K_TEXT1")
    private String zt012kText1;

    /**
     * 返回状态
     */
    @Column(name = "MSGTY")
    private String msgty;

    /**
     * 返回消息
     */
    @Column(name = "MSGTX")
    private String msgtx;


    private static final long serialVersionUID = 1L;
}