package com.huigou.topsun.sap.costReimbursement.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

/**
 * 
 * @TableName sap_cost_reimbursement_base_info
 */
@Table(name="sap_cost_reimbursement_base_info")
@Entity
@Data
public class SapCostReimbursement extends FlowBillAbstractEntity {


    /**
     * EP付款申请类别
     */
    @Column(name = "ZEP_FTYPE")
    private String zepFtype;

    /**
     * EP付款申请类别名称
     */
    @Column(name = "ZEP_FTYPENAME")
    private String zepFtypename;

    /**
     * 公司代码
     */
    @Column(name = "BUKRS")
    private String bukrs;

    /**
     * 公司代码名称
     */
    @Column(name = "BUTXT")
    private String butxt;

    /**
     * EP部门代码
     */
    @Column(name = "ZEP_DEPART")
    private String zepDepart;

    /**
     * EP部门名称
     */
    @Column(name = "ZEP_DEPARTNAME")
    private String zepDepartname;

    /**
     * EP流程申请人代码
     */
    @Column(name = "ZEP_APPLI")
    private String zepAppli;

    /**
     * EP流程申请人
     */
    @Column(name = "ZEP_APPLINAME")
    private String zepAppliname;

    /**
     * 付款申请创建日期
     */
    @Column(name = "ZEP_FCRDATE")
    private Date zepFcrdate;

    /**
     * EP流程单号
     */
    @Column(name = "ZEP_NO")
    private String zepNo;

    /**
     * 付款申请内容
     */
    @Column(name = "ZEP_TXT")
    private String zepTxt;

    /**
     * 申请总金额（本位币）
     */
    @Column(name = "ZEP_FTAMOUNT")
    private BigDecimal zepFtamount;

    /**
     * 申请总税额（本位币）
     */
    @Column(name = "ZEP_FTTAX")
    private BigDecimal zepFttax;

    /**
     * 申请总金额
     */
    @Column(name = "ZEP_FTAMOUNT1")
    private BigDecimal zepFtamount1;

    /**
     * 申请总税额
     */
    @Column(name = "ZEP_FTTAX1")
    private BigDecimal zepFttax1;

    /**
     * 审批总金额（本位币）
     */
    @Column(name = "ZEP_PTAMOUNT")
    private BigDecimal zepPtamount;

    /**
     * 审批总税额（本位币）
     */
    @Column(name = "ZEP_PTTAX")
    private BigDecimal zepPttax;

    /**
     * 审批总金额
     */
    @Column(name = "ZEP_PTAMOUNT1")
    private BigDecimal zepPtamount1;

    /**
     * 审批总税额
     */
    @Column(name = "ZEP_PTTAX1")
    private BigDecimal zepPttax1;


    @Override
    protected String getCodeRuleId() {
        return "sapCostReimbursement";
    }
}