package com.huigou.topsun.sap.costReimbursement.controller;


import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.costReimbursement.application.SapCostReimbursementApplication;
import com.huigou.topsun.sap.costReimbursement.application.SapCostReimbursementDetailApplication;
import com.huigou.topsun.sap.costReimbursement.domain.SapCostReimbursement;
import com.huigou.topsun.sap.costReimbursement.domain.SapCostReimbursementDetail;
import com.huigou.topsun.sap.costReimbursement.domain.query.SapCostReimbursementQueryRequest;
import com.huigou.topsun.sap.statsIndicators.application.SapStatsIndicatorsApplication;
import com.huigou.topsun.sap.statsIndicators.application.SapStatsIndicatorsDetailApplication;
import com.huigou.topsun.sap.statsIndicators.domain.SapStatsIndicators;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsDetailQueryRequest;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;


@Controller
@ControllerMapping("/sapCostReimbursement")
public class SapCostReimbursementController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/sap/costReimbursement/";
    }

    @Autowired
    SapCostReimbursementApplication costReimbursementApplication;
    @Autowired
    SapCostReimbursementDetailApplication costReimbursementDetailApplication;


    public String forwardCostReimbursementList(){
        return forward("costReimbursementList");
    }

    public String forwardCostReimbursement(){
        //定义流程
        this.putAttribute("processDefinitionKey", SapCostReimbursementApplication.PROCESS_DEFINITION_KEY);
        this.putAttribute("procUnitId", "Apply");//定义流程环节的id

        SapCostReimbursement sapCostReimbursement = new SapCostReimbursement();
        sapCostReimbursement.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();//获取当前操作员的详情信息
        sapCostReimbursement.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        sapCostReimbursement.setZepNo(sapCostReimbursement.getBillCode());
        return forward("costReimbursement",sapCostReimbursement);
    }


    public String slicedSapCostReimbursementList(){
        SDO sdo = this.getSDO();
        SapCostReimbursementQueryRequest queryRequest = sdo.toQueryRequest(SapCostReimbursementQueryRequest.class);
        Map<String, Object> map = costReimbursementApplication.slicedSapCostReimbursementQuery(queryRequest);
        return toResult(map);
    }


    public String slicedSapCostReimbursementDetailList(){
        SDO sdo = this.getSDO();
        List<SapCostReimbursementDetail> CRDetailAll = costReimbursementDetailApplication.getAllByCRId(sdo.getId());
        return toResult(CRDetailAll);
    }

    /**
     * 工作流审核跳转页面
     * @return
     */
    public String showSapCostReimbursement() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        String isDetailPage = sdo.getString("isDetailPage");
        if("true".equals(isDetailPage))this.putAttribute("isReadOnly","true");
        SapCostReimbursement costReimbursement = costReimbursementApplication.loadSapCostReimbursementById(id);
        return forward("costReimbursement",costReimbursement);
    }

    public String deleteStatsIndicators(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        costReimbursementApplication.deleteSapCostReimbursementByIds(ids);
        return success();
    }
//
//    /**
//     * 手动发送数据到sap
//     * @return
//     */
//    public String againSendSapDate(){
//        SDO sdo = this.getSDO();
//        String id = sdo.getBizId();
//        sapStatsIndicatorsApplication.sendSapDate(id);
//        return success();
//    }
}