package com.huigou.topsun.sap.costReimbursement.application.impl;


import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.sap.common.DefaultHttpClient;
import com.huigou.topsun.sap.common.serializer.MessageCodec;
import com.huigou.topsun.sap.costReimbursement.application.SapCostReimbursementApplication;
import com.huigou.topsun.sap.costReimbursement.domain.SapCostReimbursement;
import com.huigou.topsun.sap.costReimbursement.domain.SapCostReimbursementDetail;
import com.huigou.topsun.sap.costReimbursement.domain.query.SapCostReimbursementQueryRequest;
import com.huigou.topsun.sap.costReimbursement.repostiory.SapCostReimbursementDetailRepository;
import com.huigou.topsun.sap.costReimbursement.repostiory.SapCostReimbursementRepository;
import com.huigou.topsun.sap.statsIndicators.domain.SapStatsIndicators;
import com.huigou.topsun.sap.statsIndicators.domain.SapStatsIndicatorsDetail;
import com.huigou.topsun.sap.statsIndicators.domain.SapStatsIndicatorsResult;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsQueryRequest;
import com.huigou.topsun.util.MyBaseUtil;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import com.huigou.util.SDO;
import lombok.SneakyThrows;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service("sapCostReimbursementApplication")
public class SapCostReimbursementApplicationImpl extends FlowBroker implements SapCostReimbursementApplication {

    @Autowired
    private SapCostReimbursementDetailRepository costReimbursementDetailRepository;
    @Autowired
    private SapCostReimbursementRepository costReimbursementRepository;


//    @Autowired
//    DefaultHttpClient defaultHttpClient;
//    @Autowired
//    MessageCodec messageCodec;


    @SneakyThrows
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        SDO sdo = this.getBizAndApprovalData();
        SapCostReimbursement sapCostReimbursement = getBizEntity(SapCostReimbursement.class);
        if (sapCostReimbursement.isNew()) {
            sapCostReimbursement.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            sapCostReimbursement = (SapCostReimbursement) commonDomainService.loadAndFillinProperties(sapCostReimbursement);
        }
        sapCostReimbursement = costReimbursementRepository.save(sapCostReimbursement);


        String CRDetailJSON = sdo.getString("CRDetail");
        ObjectMapper objectMapper = new ObjectMapper();
        List<SapCostReimbursementDetail>  CRDetailAll = costReimbursementDetailRepository.findAllByReimbursementBaseInfoId(sapCostReimbursement.getId());
        if (!CRDetailAll.isEmpty()) {
            costReimbursementDetailRepository.delete(CRDetailAll);
        }
        List<SapCostReimbursementDetail> CRDetailList = objectMapper.readValue(CRDetailJSON, new TypeReference<List<SapCostReimbursementDetail>>() {});
        for (SapCostReimbursementDetail item : CRDetailList) {
            item.setReimbursementBaseInfoId(sapCostReimbursement.getId());
        }
        costReimbursementDetailRepository.save(CRDetailList);
        return sapCostReimbursement.getId();
    }


    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        // 返回业务数据给流程实例，
        return ClassHelper.toMap(costReimbursementRepository.getOne(bizId));
    }


    /**
     * 流程实例结束
     *
     * @param delegateExecution
     */
    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        SapCostReimbursement sapCostReimbursement = costReimbursementRepository.findOne(bizId);
        sapCostReimbursement.setStatusId(status.getId());
        costReimbursementRepository.save(sapCostReimbursement);
        //审核完成、远程调用sap接口
        sendSapDate(bizId);
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        SapCostReimbursement sapCostReimbursement = costReimbursementRepository.findOne(bizId);
        sapCostReimbursement.setStatusId(BizBillStatus.ABORTED.getId());
        costReimbursementRepository.save(sapCostReimbursement);
    }

    /**
     * @param delegateTask
     * @param destActivityId 回退到的目标节点id
     */
    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            SapCostReimbursement sapCostReimbursement = costReimbursementRepository.findOne(bizId);
            sapCostReimbursement.setStatusId(BizBillStatus.APPLYING.getId());
            costReimbursementRepository.save(sapCostReimbursement);
        }
    }

    @Override
    public SapCostReimbursement loadSapCostReimbursementById(String id) {
        return costReimbursementRepository.findOne(id);
    }

    @Override
    public Map<String, Object> slicedSapCostReimbursementQuery(SapCostReimbursementQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedSapCostReimbursementQuery");
        return this.sqlExecutorDao.executeSlicedQuery(queryDescriptor, query);
    }


    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void deleteSapCostReimbursementById(String id) {
        SapCostReimbursement costReimbursement = costReimbursementRepository.findOne(id);
        List<SapCostReimbursementDetail> all = costReimbursementDetailRepository.findAllByReimbursementBaseInfoId(id);
        costReimbursementDetailRepository.delete(all);
        costReimbursementRepository.delete(costReimbursement);
    }

    @Override
    @Transactional
    public void deleteSapCostReimbursementByIds(List<String> ids) {
        ids.forEach(this::deleteSapCostReimbursementById);
    }


    /**
     * 远程调用sap接口，传递数据
     *
     * @param bizId
     */
    public void sendSapDate(String bizId) {
        SapCostReimbursement sapCostReimbursement = costReimbursementRepository.findOne(bizId);
        if (sapCostReimbursement.getStatusId() == BizBillStatus.APPLYING.getId()) {
            throw new RuntimeException("本数据未经审批完成！");
        }


        List<SapCostReimbursementDetail> all = costReimbursementDetailRepository.findAllByReimbursementBaseInfoId(bizId);

        List<Map<String, Object>> list = new ArrayList<>();
        ObjectMapper objectMapper = new ObjectMapper();
        Map<String, Object> map = MyBaseUtil.convertToMap(sapCostReimbursement,true);




        //封装参数
//        for (SapStatsIndicatorsDetail sapStatsIndicatorsDetail : all) {
//            Map<String, Object> detailMap = objectMapper.convertValue(sapStatsIndicatorsDetail, Map.class);
//            map.put("ITEM", detailMap);
//            list.add(map);
//        }

//        String url = "cud_kb31n/kb31n";
//        SapStatsIndicatorsResult sapStatsIndicatorsResult = null;
//        try {
//            String result = defaultHttpClient.execute(list, url);
//            List<SapStatsIndicatorsResult> resultList = objectMapper.readValue(result, new TypeReference<List<SapStatsIndicatorsResult>>() {
//            });
//
//            sapStatsIndicatorsResult = resultList.get(0);
//
//            if (!"s".equals(sapStatsIndicatorsResult.getType())) {
//                throw new RuntimeException("数据传输失败，请稍后手动重试！");
//            }
//        } catch (IOException e) {
//            if (sapStatsIndicatorsResult == null) {
//                sapStatsIndicatorsResult = new SapStatsIndicatorsResult();
//            }
//            sapStatsIndicatorsResult.setType("A");
//            throw new RuntimeException("sap服务器无响应请稍后手动重试！");
//        } finally {
//            SapStatsIndicatorsResult statsIndicatorsId = sapStatsIndicatorsResultRepository.findByStatsIndicatorsId(bizId);
//            if(statsIndicatorsId!=null)sapStatsIndicatorsResultRepository.delete(statsIndicatorsId);
//            sapStatsIndicatorsResult.setStatsIndicatorsId(bizId);
//            sapStatsIndicatorsResultRepository.save(sapStatsIndicatorsResult);
//        }
    }

}