package com.huigou.topsun.sap.costCenter.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/29
 * description:
 * 成本中心新增-返回给SAP的封装类
 */
@JsonIgnoreProperties
public class CostCenterReturnVo implements Serializable {

    /**
     * 成本中心编码
     */
    @JsonProperty("KOSTL")
    private String kostl;

    /**
     * 有效期自 默认当年1月1日
     */
    @JsonProperty("DATAB")
    @JsonFormat(pattern = "yyyy.MM.dd", timezone = "GTM-8")
    private Date datab;

    /**
     * 有效截至日 默认9999.12.31
     */
    @JsonProperty("DATBI")
    @JsonFormat(pattern = "yyyy.MM.dd", timezone = "GTM-8")
    private Date datbi;

    /**
     * 名称
     */
    @JsonProperty("KTEXT")
    private String ktext;

    /**
     * 描述
     */
    @JsonProperty("LTEXT")
    private String ltext;

    /**
     * 负责人
     */
    @JsonProperty("VERAK")
    private String verak;

    /**
     * 成本中心类型
     * 管理类	L
     * 销售类	V
     * 研发类	E
     * 间接生产类	G
     * 直接生产类	F
     */
    @JsonProperty("KOSAR")
    private String kosar;

    /**
     * 利润中心
     * 10001000 广州宝绅科技利润中心
     * 10001001 广州宝绅RFID利润中心
     */
    @JsonProperty("PRCTR")
    private String prctr;

    public String getKostl() {
        return kostl;
    }

    public void setKostl(String kostl) {
        this.kostl = kostl;
    }

    public Date getDatab() {
        return datab;
    }

    public void setDatab(Date datab) {
        this.datab = datab;
    }

    public Date getDatbi() {
        return datbi;
    }

    public void setDatbi(Date datbi) {
        this.datbi = datbi;
    }

    public String getKtext() {
        return ktext;
    }

    public void setKtext(String ktext) {
        this.ktext = ktext;
    }

    public String getLtext() {
        return ltext;
    }

    public void setLtext(String ltext) {
        this.ltext = ltext;
    }

    public String getVerak() {
        return verak;
    }

    public void setVerak(String verak) {
        this.verak = verak;
    }

    public String getKosar() {
        return kosar;
    }

    public void setKosar(String kosar) {
        this.kosar = kosar;
    }

    public String getPrctr() {
        return prctr;
    }

    public void setPrctr(String prctr) {
        this.prctr = prctr;
    }

    public CostCenterReturnVo( String kostl, Date datab, Date datbi, String ktext, String ltext, String verak, String kosar, String prctr) {

        this.kostl = kostl;
        this.datab = datab;
        this.datbi = datbi;
        this.ktext = ktext;
        this.ltext = ltext;
        this.verak = verak;
        this.kosar = kosar;
        this.prctr = prctr;
    }

    public CostCenterReturnVo() {
    }
}
