package com.huigou.topsun.sap.costCenter.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/14
 * description:
 */
@Data
public class CostCenterQueryRequest extends QueryAbstractRequest {
    /**
     * id
     */
    private String id;
    /**
     * 成本中心编码
     */
    private String kostl;

    /**
     * 有效期自 默认当年1月1日
     */
    private Date datab;

    /**
     * 有效截至日 默认9999.12.31
     */
    private Date datbi;

    /**
     * 名称
     */
    private String ktext;

    /**
     * 描述
     */
    private String ltext;

    /**
     * 负责人
     */
    private String verak;

    /**
     * 成本中心类型
     * 管理类	L
     * 销售类	V
     * 研发类	E
     * 间接生产类	G
     * 直接生产类	F
     */
    private String kosar;

    /**
     * 利润中心
     * 10001000 广州宝绅科技利润中心
     * 10001001 广州宝绅RFID利润中心
     */
    private String prctr;

    /**
     * 冻结0 启用1
     */
    private String is_delete;

    /**
     * 创建原因	CHAR	100	手工输入
     */
    private String reason;

    private Long version;
    private Date fillinDate;

    private String billCode;

    private Integer statusId;

    private String fullId;

    private String organId;

    private String organName;

    private String deptId;

    private String deptName;

    private String positionId;

    private String positionName;

    private String personMemberId;

    private String personMemberName;

    private String telePhone;
}
