package com.huigou.topsun.sap.costCenter.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.costCenter.application.CostCenterApplication;
import com.huigou.topsun.sap.costCenter.domain.CostCenter;
import com.huigou.topsun.sap.costCenter.domain.query.CostCenterQueryRequest;
import com.huigou.topsun.sap.costCenter.domain.vo.CostCenterVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bmp.common.easysearch.EasySearch;
import com.huigou.uasp.bmp.common.easysearch.domain.model.EasySearchParse;
import com.huigou.uasp.bmp.common.easysearch.domain.model.QuerySchemeField;
import com.huigou.uasp.bmp.opm.application.MemEasySearcher;
import com.huigou.uasp.bmp.opm.application.impl.MemEasySearcherImpl;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/13/11:36
 * @Description:
 */
@Controller
@ControllerMapping("/sapCostCenter")
public class CostCenterController extends CommonController {

    @Autowired
    private CostCenterApplication costCenterApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/costCenter/";
    }


    /**
     * 跳转到成本中心查询列表
     *
     * @return
     */
    public String forwardSapCostCenterList() {
        return forward("sapCostCenterList");
    }

    public String slicedCostCenterList() {
        SDO sdo = this.getSDO();
        CostCenterQueryRequest costCenterQueryRequest = sdo.toQueryRequest(CostCenterQueryRequest.class);

        return toResult(costCenterApplication.getCostCenterList(costCenterQueryRequest));
    }

    /**
     * 跳转到新增页面
     */
    public String addCostCenterDetail() {
        this.putAttribute("processDefinitionKey", costCenterApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        CostCenter costCenter = new CostCenter();
        costCenter.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        costCenter.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));

        return forward("sapCostCenterDetail", costCenter);
    }

    /**
     * 跳转到增固定资产页面
     */
    public String showCostCenter() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        CostCenterVo costCenterVo = costCenterApplication.findCostCenterById(id);
        return forward("sapCostCenterDetail", costCenterVo);
    }

    /**
     * 根据id获取成本中心信息
     *
     * @return
     */
    public String showCostCenterDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        CostCenterVo costCenterVo = costCenterApplication.findCostCenterById(id);
        return forward("sapCostCenterDetail", costCenterVo);

    }

    /**
     * 根据id删除成本中心
     *
     * @return
     */
    public String deleteCostCenterById() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();

        costCenterApplication.deleteCostCenterById(ids);
        return success();

    }

    /**
     * 保存/修改 成本中心
     *
     * @return
     */
    public String saveCostCenter() {
        SDO sdo = this.getSDO();
        CostCenterVo costCenterVo = sdo.toObject(CostCenterVo.class);
        CostCenter costCenter = CostCenterVo.getCostCenter(costCenterVo);
//        if (StringUtil.isNotBlank(costCenter.getId()))
//            costCenterApplication.updateCostCenter(costCenter);
//        else
//            costCenterApplication.saveCostCenter(costCenter);
//        return "";
        costCenterVo = costCenterApplication.saveAndUpdate(costCenter);

        return success(costCenterVo);
    }

    /**
     * 成本中心ES查询接口
     */
    @EasySearch(queryName = "queryCostCenter")
    public Map<String, Object> queryCostCenter(SDO sdo) {
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize", 10);
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        List<QuerySchemeField> fields =
                Arrays.asList(new QuerySchemeField("id", "id", "hidden"),
                        new QuerySchemeField("成本中心编码", "kostl", "string", 200L),
                        new QuerySchemeField("名称", "ktext", "string", 200L)
                );
        EasySearchParse easySearchParse = new EasySearchParse();
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(400L);
        String ktext = sdo.getString("ktext");
        CostCenterQueryRequest queryRequest = sdo.toQueryRequest(CostCenterQueryRequest.class);
        queryRequest.setKtext(ktext);
        Map<String, Object> map = costCenterApplication.slicedCostCenterList(queryRequest);
        List<Map<String, Object>> mapList = (List<Map<String, Object>>) map.get("Rows");
        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
        return model;
    }

    /**
     * 冻结成本中心
     */
    public String updateCostCenterStatus() {
        // TODO 需要向ICP发送冻结信息
        List<String> ids = this.getSDO().getIds();
        int flog = costCenterApplication.updateCostCenterStatus(ids);
        if (flog == 1)
            return success();
        return error("失败");
    }
}
