package com.huigou.topsun.proofing.domain.proofingMake.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样制造单（排版参数）
 * @TableName proofing_make_pd_published_conf
 */
@Table(name="proofing_make_pd_published_conf")
@Entity
@Data
public class ProofingMakePdPublishedConf implements Serializable {
    /**
     * 打样制作单排版参数id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_make_pd_published_conf_id")
    private String proofingMakePdPublishedConfId;

    /**
     * 打样制作单id
     */
    @Column(name = "proofing_make_id")
    private String proofingMakeId;

    /**
     * 模数
     */
    private Integer modulus;

    /**
     * 行数
     */
    @Column(name = "row_num")
    private Integer rowNum;

    /**
     * 列数
     */
    @Column(name = "column_num")
    private Integer columnNum;

    /**
     * 搭版数
     */
    @Column(name = "contact_num")
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    @Column(name = "row_double_blade")
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    @Column(name = "column_double_blade")
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    @Column(name = "dispatch_multiple")
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    @Column(name = "sheet_length")
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    @Column(name = "sheet_width")
    private Double sheetWidth;

    /**
     * 印刷正面颜色
     */
    @Column(name = "print_front_coler")
    private String printFrontColer;

    /**
     * 印刷反面颜色
     */
    @Column(name = "print_opposite_color")
    private String printOppositeColor;

    private static final long serialVersionUID = 1L;
}