package com.huigou.topsun.proofing.domain.proofingMake.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样制作单BOM
 * @TableName proofing_make_bom
 */
@Table(name = "proofing_make_bom")
@Entity
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProofingMakeBom implements Serializable {
    /**
     * 打样制作单BOMid
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_make_bom_id")
    @JsonIgnore
    private String proofingMakeBomId;

    /**
     * 产品物料组成id
     */
    @Column(name = "product_material_id")
    @JsonProperty(value = "materialId", required = true)
    private String productMaterialId;

    /**
     * 打样制作单id
     */
    @Column(name = "proofing_make_id")
    @JsonIgnore
    private String proofingMakeId;

    /**
     * 数量
     */
    @Column(name = "proofing_make_bom_num")
    @JsonProperty(value = "materialNumber", required = true)
    private String proofingMakeBomNum;

    /**
     * 物料名称
     */
    @Column(name = "product_material_name")
    @JsonProperty(value = "materialName", required = true)
    private String productMaterialName;

    /**
     * 组件计量单位
     */
    @Column(name = "proofing_make_bom_meins")
    @JsonProperty(value = "materialUnit", required = true)
    private String proofingMakeBomMeins;

    /**
     * 组件报废百分比
     */
    @Column(name = "proofing_make_bom_ausch")
    @JsonProperty(value = "AUSCH", required = true)
    private Double proofingMakeBomAusch;

    /**
     * BOM项目文本(行1)
     */
    @Column(name = "proofing_make_bom_text")
    @JsonProperty(value = "POTX1", required = true)
    private String proofingMakeBomText;

    /**
     * 物料清单项目文本(行2)
     */
    @Column(name = "proofing_make_bom_material_text")
    @JsonProperty(value = "materialJson", required = true)
    private String proofingMakeBomMaterialText;

    /**
     * 替代组
     */
    @Column(name = "proofing_make_bom_alpgr")
    @JsonProperty(value = "ALPGR", required = true)
    private String proofingMakeBomAlpgr;

    /**
     * 替代优先级
     */
    @Column(name = "proofing_make_bom_alprf")
    @JsonProperty(value = "ALPRF", required = true)
    private Integer proofingMakeBomAlprf;

    /**
     * 策略
     */
    @Column(name = "proofing_make_bom_alpst")
    @JsonProperty(value = "ALPST", required = true)
    private String proofingMakeBomAlpst;

    /**
     * 使用概率
     */
    @Column(name = "proofing_make_bom_ewahr")
    @JsonProperty(value = "EWAHR", required = true)
    private Long proofingMakeBomEwahr;

    /**
     * 物料项次
     */
    @Column(name = "proofing_make_bom_item_number")
    @JsonProperty(value = "ITEM_NUMBRE", required = true)
    private String proofingMakeBomItemNumber;

    /**
     * 物料类别
     */
    @Column(name = "proofing_make_bom_category")
    @JsonProperty(value = "CATEGORY", required = true)
    private String proofingMakeBomCategory;

    /**
     * 采购
     */
    @Column(name = "proofing_make_bom_procure")
    @JsonProperty(value = "PROCURE", required = true)
    private String proofingMakeBomProcure;

    /**
     * 备注
     */
    @Column(name = "proofing_make_bom_note")
    @JsonProperty(value = "NOTE", required = true)
    private String proofingMakeBomNote;

    private static final long serialVersionUID = 1L;

    public String getProofingMakeBomId() {
        return proofingMakeBomId;
    }

    public void setProofingMakeBomId(String proofingMakeBomId) {
        this.proofingMakeBomId = proofingMakeBomId;
    }

    public String getProductMaterialId() {
        return productMaterialId;
    }

    public void setProductMaterialId(String productMaterialId) {
        this.productMaterialId = productMaterialId;
    }

    public String getProofingMakeId() {
        return proofingMakeId;
    }

    public void setProofingMakeId(String proofingMakeId) {
        this.proofingMakeId = proofingMakeId;
    }

    public String getProofingMakeBomNum() {
        return proofingMakeBomNum;
    }

    public void setProofingMakeBomNum(String proofingMakeBomNum) {
        this.proofingMakeBomNum = proofingMakeBomNum;
    }

    public String getProductMaterialName() {
        return productMaterialName;
    }

    public void setProductMaterialName(String productMaterialName) {
        this.productMaterialName = productMaterialName;
    }

    public String getProofingMakeBomMeins() {
        return proofingMakeBomMeins;
    }

    public void setProofingMakeBomMeins(String proofingMakeBomMeins) {
        this.proofingMakeBomMeins = proofingMakeBomMeins;
    }

    public Double getProofingMakeBomAusch() {
        return proofingMakeBomAusch;
    }

    public void setProofingMakeBomAusch(Double proofingMakeBomAusch) {
        this.proofingMakeBomAusch = proofingMakeBomAusch;
    }

    public String getProofingMakeBomText() {
        return proofingMakeBomText;
    }

    public void setProofingMakeBomText(String proofingMakeBomText) {
        this.proofingMakeBomText = proofingMakeBomText;
    }

    public String getProofingMakeBomMaterialText() {
        return proofingMakeBomMaterialText;
    }

    public void setProofingMakeBomMaterialText(String proofingMakeBomMaterialText) {
        this.proofingMakeBomMaterialText = proofingMakeBomMaterialText;
    }

    public String getProofingMakeBomAlpgr() {
        return proofingMakeBomAlpgr;
    }

    public void setProofingMakeBomAlpgr(String proofingMakeBomAlpgr) {
        this.proofingMakeBomAlpgr = proofingMakeBomAlpgr;
    }

    public Integer getProofingMakeBomAlprf() {
        return proofingMakeBomAlprf;
    }

    public void setProofingMakeBomAlprf(Integer proofingMakeBomAlprf) {
        this.proofingMakeBomAlprf = proofingMakeBomAlprf;
    }

    public String getProofingMakeBomAlpst() {
        return proofingMakeBomAlpst;
    }

    public void setProofingMakeBomAlpst(String proofingMakeBomAlpst) {
        this.proofingMakeBomAlpst = proofingMakeBomAlpst;
    }

    public Long getProofingMakeBomEwahr() {
        return proofingMakeBomEwahr;
    }

    public void setProofingMakeBomEwahr(Long proofingMakeBomEwahr) {
        this.proofingMakeBomEwahr = proofingMakeBomEwahr;
    }

    public String getProofingMakeBomItemNumber() {
        return proofingMakeBomItemNumber;
    }

    public void setProofingMakeBomItemNumber(String proofingMakeBomItemNumber) {
        this.proofingMakeBomItemNumber = proofingMakeBomItemNumber;
    }

    public String getProofingMakeBomCategory() {
        return proofingMakeBomCategory;
    }

    public void setProofingMakeBomCategory(String proofingMakeBomCategory) {
        this.proofingMakeBomCategory = proofingMakeBomCategory;
    }

    public String getProofingMakeBomProcure() {
        return proofingMakeBomProcure;
    }

    public void setProofingMakeBomProcure(String proofingMakeBomProcure) {
        this.proofingMakeBomProcure = proofingMakeBomProcure;
    }

    public String getProofingMakeBomNote() {
        return proofingMakeBomNote;
    }

    public void setProofingMakeBomNote(String proofingMakeBomNote) {
        this.proofingMakeBomNote = proofingMakeBomNote;
    }
}