package com.huigou.topsun.proofing.domain.proofingMake.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 打样制作单基本信息
 * @TableName proofing_make_base_info
 */
@Table(name="proofing_make_base_info")
@Entity
@Data
public class ProofingMakeBaseInfo implements Serializable {


    /**
     * 制作单id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_make_id")
    private String proofingMakeId;

    /**
     * 制作单号
     */
    @Column(name = "proofing_make_no")
    private String proofingMakeNo;

    /**
     * 打样申请单id
     */
    @Column(name = "proofing_apply_id")
    private String proofingApplyId;

    /**
     * 申请单号
     */
    @Column(name = "proofing_apply_no")
    private String proofingApplyNo;

    /**
     * 产品Id
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 产品Id
     */
    @Column(name = "product_Code")
    private String productCode;

    /**
     * 品牌客户编号
     */
    @Column(name = "customer_code")
    private String customerCode;
    /**
     * 版面
     */
    private String page;
    /**
     * 版面需求时间
     */
    @Column(name = "proofing_make_page_need_time")
    private Date proofingMakePageNeedTime;

    /**
     * 完成日期
     */
    @Column(name = "proofing_make_complete_date")
    private Date proofingMakeCompleteDate;

    /**
     * 样品中文名称
     */
    @Column(name = "proofing_make_sample_cn_name")
    private String proofingMakeSampleCnName;

    /**
     * 样品英文名称
     */
    @Column(name = "proofing_make_sample_en_name")
    private String proofingMakeSampleEnName;

    /**
     * 样品版次
     */
    @Column(name = "proofing_make_sample_version")
    private Integer proofingMakeSampleVersion;

    /**
     * 样品规格
     */
    @Column(name = "proofing_make_sample_size")
    private Integer proofingMakeSampleSize;

    /**
     * 样品款式
     */
    @Column(name = "sample_style")
    private String sampleStyle;

    /**
     * 样品数量
     */
    @Column(name = "proofing_make_sample_num")
    private Long proofingMakeSampleNum;

    /**
     * 产量情况
     */
    @Column(name = "proofing_make_output_situation")
    private String proofingMakeOutputSituation;

    /**
     * 产品代号
     */
    @Column(name = "proofing_make_product_no")
    private String proofingMakeProductNo;
    /**
     * 产品类别名称
     */
    @Column(name = "product_category_name")
    private String productCategoryName;


    /**
     * 打样形式
     */
    @Column(name = "proofing_type")
    private String proofingType;

    /**
     * 分配方式
     */
    @Column(name = "proofing_make_allocation_type")
    private String proofingMakeAllocationType;

    /**
     * 表面处理
     */
    @Column(name = "proofing_make_surface_treatment")
    private String proofingMakeSurfaceTreatment;

    /**
     * NG重新打样原因
     */
    @Column(name = "proofing_make_ng_re_reason")
    private String proofingMakeNgReReason;

    /**
     * 申请单状态
     */
    @Column(name = "proofing_apply_application_status")
    private String proofingApplyApplicationStatus;

    /**
     * 测试标准
     */
    @Column(name = "proofing_make_test_standard")
    private String proofingMakeTestStandard;

    /**
     * 颜色种类
     */
    @Column(name = "color_type")
    private String colorType;

    /**
     * 专
     */
    private String expert;

    /**
     * 网版目数
     */
    @Column(name = "printing_plate_num")
    private Integer printingPlateNum;

    /**
     * 啤板模数
     */
    @Column(name = "beer_plate_num")
    private Integer beerPlateNum;

    /**
     * 模切板模数
     */
    @Column(name = "die_board_num")
    private Integer dieBoardNum;

    /**
     * 标准色号
     */
    @Column(name = "standard_color")
    private String standardColor;

    /**
     * 是否删除
     */
    @Column(name = "is_delete")
    private String isDelete;

    public ProofingMakeBaseInfo(){
        this.isDelete="0";
    }
    private static final long serialVersionUID = 1L;
}