package com.huigou.topsun.proofing.domain.proofingApply.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样申请bom信息
 *
 * @TableName proofing_apply_bom
 */
@Table(name = "proofing_apply_bom")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProofingApplyBom implements Serializable {
    /**
     * 打样申请单BOMid
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_apply_bom_id")
    @JsonProperty(value = "proofingApplyBomId", required = true)
    private String proofingApplyBomId;

    /**
     * 产品物料组成id
     */
    @Column(name = "product_material_id")
    @JsonProperty(value = "materialId", required = true)
    private String productMaterialId;

    /**
     * 打样申请单id
     */
    @Column(name = "proofing_apply_id")
    private String proofingApplyId;

    /**
     * 数量
     */
    @Column(name = "proofing_apply_bom_num")
    @JsonProperty(value = "materialNumber", required = true)
    private String proofingApplyBomNum;

    /**
     * 物料名称
     */
    @Column(name = "product_material_name")
    @JsonProperty(value = "materialName", required = true)
    private String productMaterialName;

    /**
     * 组件计量单位
     */
    @Column(name = "proofing_apply_bom_meins")
    @JsonProperty(value = "materialUnit", required = true)
    private String proofingApplyBomMeins;

    /**
     * 组件报废百分比
     */
    @Column(name = "proofing_apply_bom_ausch")
    @JsonProperty(value = "AUSCH", required = true)
    private Double proofingApplyBomAusch;

    /**
     * BOM项目文本(行1)
     */
    @Column(name = "proofing_apply_bom_text")
    @JsonProperty(value = "POTX1", required = true)
    private String proofingApplyBomText;

    /**
     * 物料清单项目文本(行2)
     */
    @Column(name = "proofing_apply_bom_material_text")
    @JsonProperty(value = "materialJson", required = true)
    private String proofingApplyBomMaterialText;

    /**
     * 替代组
     */
    @Column(name = "proofing_apply_bom_alpgr")
    @JsonProperty(value = "ALPGR", required = true)
    private String proofingApplyBomAlpgr;

    /**
     * 替代优先级
     */
    @Column(name = "proofing_apply_bom_alprf")
    @JsonProperty(value = "ALPRF", required = true)
    private Integer proofingApplyBomAlprf;

    /**
     * 策略
     */
    @Column(name = "proofing_apply_bom_alpst")
    @JsonProperty(value = "ALPST", required = true)
    private String proofingApplyBomAlpst;

    /**
     * 使用概率
     */
    @Column(name = "proofing_apply_bom_ewahr")
    @JsonProperty(value = "EWAHR", required = true)
    private Long proofingApplyBomEwahr;

    /**
     * 物料项次
     */
    @Column(name = "proofing_apply_bom_item_number")
    @JsonProperty(value = "ITEM_NUMBRE", required = true)
    private String proofingApplyBomItemNumber;

    /**
     * 物料类别
     */
    @Column(name = "proofing_apply_bom_category")
    @JsonProperty(value = "CATEGORY", required = true)
    private String proofingApplyBomCategory;

    /**
     * 采购
     */
    @Column(name = "proofing_apply_bom_procure")
    @JsonProperty(value = "PROCURE", required = true)
    private String proofingApplyBomProcure;

    /**
     * 备注
     */
    @Column(name = "proofing_apply_bom_note")
    @JsonProperty(value = "NOTE", required = true)
    private String proofingApplyBomNote;

    private static final long serialVersionUID = 1L;
}