package com.huigou.topsun.proofing.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.product.application.ProductApplication;
import com.huigou.topsun.product.application.ProductLookedApplication;
import com.huigou.topsun.product.domain.ProductLooked;
import com.huigou.topsun.product.domain.vo.ProductAllDataVo;
import com.huigou.topsun.proofing.application.*;

import com.huigou.topsun.proofing.domain.proofingApply.model.ProofingApplyBaseInfo;
import com.huigou.topsun.proofing.domain.proofingApply.model.ProofingApplyLooked;
import com.huigou.topsun.proofing.domain.proofingApply.query.ProofingApplyProcessQueryRequest;
import com.huigou.topsun.proofing.domain.proofingApply.query.ProofingApplyQuery;
import com.huigou.topsun.proofing.domain.proofingApply.query.ProofingApplyTechnologyQueryRequest;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeProcessQueryRequest;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeTechnologyQueryRequest;
import com.huigou.topsun.proofing.domain.vo.ProofingApplyBaseInfoVo;
import com.huigou.topsun.technology.application.TechnologyApplication;
import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.query.TechnologyQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

@Controller
@ControllerMapping("/proofingApply")
public class ProofingApplyController extends CommonController {
    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }

    @Autowired
    ProofingApplyApplication proofingApplyApplication;
    @Autowired
    ProofingApplyLookedApplication proofingApplyLookedApplication;
    @Autowired
    ProductLookedApplication productLookedApplication;

    /**
     * 打样申请详情
     * @return
     */
        public String slicedProofingApplyList(){
            SDO sdo = this.getSDO();
            ProofingApplyQuery queryRequest = sdo.toQueryRequest(ProofingApplyQuery.class);
            Map<String, Object> map = proofingApplyApplication.slicedQuery(queryRequest);
            return toResult(map);
    }

    public String forwardProofingApplyList(){
        return forward("proofingApplyList");
    }


    /**
     * 打样表单页
     * @return
     */
    public String forwardProofingApply(){
        this.putAttribute("processDefinitionKey",ProofingApplyApplication.PROCESS_DEFINITION_KEY);
        this.putAttribute("procUnitId", "Apply");//定义流程环节的id
        ProofingApplyBaseInfo proofingApply = new ProofingApplyBaseInfo();
        proofingApply.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();//获取当前操作员的详情信息
        proofingApply.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        proofingApply.setProofingApplyNo(proofingApply.getBillCode()); //将生成的单号赋予实体类对应字段
        String id = UUID.randomUUID().toString().replace("-", "");
        proofingApply.setProofingApplyId(id);
        return forward("proofingApply",proofingApply);
    }

    /**
     * 工作流审核跳转页面
     * @return
     */
    public String showProofingApply() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        String isDetailPage = sdo.getString("isDetailPage");
        if("true".equals(isDetailPage)) this.putAttribute("isDetailPage","true");
        ProofingApplyBaseInfo proofingApply = proofingApplyApplication.loadProofingApplyById(id);
        ProofingApplyLooked proofingApplyLooked = proofingApplyLookedApplication.findByProofingApplyId(proofingApply.getProofingApplyId());
        ProofingApplyBaseInfoVo vo =new ProofingApplyBaseInfoVo();
        BeanUtils.copyProperties(proofingApply,vo);
        BeanUtils.copyProperties(proofingApplyLooked,vo);
        return forward("proofingApply", vo);
    }

    /**
     * 根据产品编号获取外观详情
     * @return
     */
    public String queryProductLooked(){
        SDO sdo = this.getSDO();
        String productId = sdo.getString("productId");
        ProductLooked productLooked = new ProductLooked();
        productLooked.setProductId(productId);
        ProductLooked newProductLooked = productLookedApplication.getProductLookedByEntity(productLooked);
        return toResult(newProductLooked);
    }


}
