package com.huigou.topsun.proofing.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.proofing.application.ProofingMakeBomApplication;
import com.huigou.topsun.proofing.domain.proofingMake.model.ProofingMakeBom;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeBomQueryRequest;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * title:
 * author:ZHT
 * date:2024/1/3
 * description:
 */
@Service
public class ProofingMakeBomApplicationImpl extends BaseApplication implements ProofingMakeBomApplication {

    @Override
    public Map<String, Object> slicedProofingMakeBom(ProofingMakeBomQueryRequest proofingMakeBomQueryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedProofingMakeBom");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, proofingMakeBomQueryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);

        // 转换为前端可以接受的数据
        ArrayList<HashMap> rows = (ArrayList) map.get("Rows");
        ArrayList<HashMap<String, Object>> proofingMakeBoms = new ArrayList<>();
        for (HashMap row : rows) {
            HashMap<String, Object> rowMap = new HashMap<>();
            rowMap.put("ALPGR", row.get("proofingMakeBomAlpgr"));
            rowMap.put("materialName", row.get("productMaterialName"));
            rowMap.put("materialNumber", row.get("proofingMakeBomNum"));
            rowMap.put("AUSCH", row.get("proofingMakeBomAusch"));
            rowMap.put("POTX1", row.get("proofingMakeBomText"));
            rowMap.put("materialJson", row.get("proofingMakeBomMaterialText"));
            rowMap.put("ALPRF", row.get("proofingMakeBomAlprf"));
            rowMap.put("ALPST", row.get("proofingMakeBomAlpst"));
            rowMap.put("EWAHR", row.get("proofingMakeBomEwahr"));
            rowMap.put("materialId", row.get("productMaterialId"));
            rowMap.put("materialUnit", row.get("proofingMakeBomMeins"));
            rowMap.put("bomId", row.get("proofingMakeBomId"));
            rowMap.put("primaryKey",row.get("proofingMakeId"));
            rowMap.put("ITEM_NUMBRE",row.get("proofingMakeBomItemNumber"));
            rowMap.put("CATEGORY",row.get("proofingMakeBomCategory"));
            rowMap.put("PROCURE",row.get("proofingMakeBomProcure"));
            rowMap.put("NOTE",row.get("proofingMakeBomNote"));
            proofingMakeBoms.add(rowMap);
        }
        map.remove("Rows");
        map.put("Rows", proofingMakeBoms);
        return map;
    }
}
