package com.huigou.topsun.proofing.application.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.cache.SystemCache;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.product.domain.*;
import com.huigou.topsun.product.repository.*;
import com.huigou.topsun.proofing.application.ProofingMakeApplication;
import com.huigou.topsun.proofing.domain.proofingMake.model.*;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeQueryRequest;
import com.huigou.topsun.proofing.domain.vo.ProofingMakeVo;
import com.huigou.topsun.proofing.repository.proofingApply.ProofingApplyRepository;
import com.huigou.topsun.proofing.repository.proofingMake.*;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.util.MyBaseUtil;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.SDO;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.*;

/**
 * @author 16508
 * @description 针对表【technology(工艺)】的数据库操作Service实现
 * @createDate 2023-11-22 11:04:03
 */
@Service
public class ProofingMakeApplicationImpl extends BaseApplication implements ProofingMakeApplication {

    @Autowired
    ProductLookedRepository productLookedRepository;

    @Autowired
    private ProductRepository productRepository;

    @Autowired
    private ProductMaterialRepository productMaterialRepository;
    @Autowired
    ProductPublishedConfRepository productPublishedConfRepository;

    @Autowired
    private ProductTechnologyRepository productTechnologyRepository;

    @Autowired
    private ProductDetailRepository productDetailRepository;

    @Autowired
    private ProductTypesetConfRepository productTypesetConfRepository;

    @Autowired
    private ProductProcessRepository productProcessRepository;
    @Autowired
    ProofingMakeRepository proofingMakeRepository;
    @Autowired
    ProofingApplyRepository proofingApplyRepository;
    @Autowired
    ProofingMakeLookedRepository proofingMakeLookedRepository;
    @Autowired
    ProofingMakePdPublishedConfRepository proofingMakePdPublishedConfRepository;
    @Autowired
    ProofingMakeTechnologyRepository proofingMakeTechnologyRepository;
    @Autowired
    ProofingMakeProcessRepository proofingMakeProcessRepository;
    @Autowired
    ProofingMakeProcessMaterialRepository proofingMakeProcessMaterialRepository;

    @Autowired
    ProofingMakeBomRepository proofingMakeBomRepository;

    @Autowired
    private HttpClient httpClient;


    @Override
    public Map<String, Object> slicedProofingMakeQuery(ProofingMakeQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedProofingMakeList");
        return this.sqlExecutorDao.executeSlicedQuery(queryDescriptor, query);
    }

    /**
     * 编辑打样制造及相关信息
     *
     * @param sdo 打样制造及相关信息
     */
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    @SneakyThrows
    @Override
    public Map<String, Object> saveProofingMake(SDO sdo) {
        // TODO 生成BOM发送到SAP 保存到商品中
        HashMap<String, Object> idMap = new HashMap<>();
        ProofingMakeBaseInfo proofingMakeBaseInfo = sdo.toObject(ProofingMakeBaseInfo.class);
        ProofingMakeLooked proofingMakeLooked = sdo.toObject(ProofingMakeLooked.class);
        ProofingMakePdPublishedConf proofingMakePdPublishedConf = sdo.toObject(ProofingMakePdPublishedConf.class);


        proofingMakeBaseInfo = proofingMakeRepository.save(proofingMakeBaseInfo);
        idMap.put("proofingMakeId", proofingMakeBaseInfo.getProofingMakeId());

        proofingMakeLooked.setProofingMakeId(proofingMakeBaseInfo.getProofingMakeId());
        proofingMakeLooked = proofingMakeLookedRepository.save(proofingMakeLooked);
        idMap.put("proofingMakeLookedId", proofingMakeLooked.getProofingMakeLookedId());

        proofingMakePdPublishedConf.setProofingMakeId(proofingMakeBaseInfo.getProofingMakeId());
        proofingMakePdPublishedConf = proofingMakePdPublishedConfRepository.save(proofingMakePdPublishedConf);
        idMap.put("proofingMakePdPublishedConfId", proofingMakePdPublishedConf.getProofingMakePdPublishedConfId());

        String technologyJSON = sdo.getString("technology");
        String processJSON = sdo.getString("process");
        String processMaterialJSON = sdo.getString("processMaterial");
        ObjectMapper objectMapper = new ObjectMapper();
        ProofingMakeTechnology proofingMakeTechnology = objectMapper.readValue(technologyJSON, ProofingMakeTechnology.class);
        List<ProofingMakeProcess> ProcessList = objectMapper.readValue(processJSON, new TypeReference<List<ProofingMakeProcess>>() {
        });
        List<ProofingMakeProcessMaterial> processMaterialList = objectMapper.readValue(processMaterialJSON, new TypeReference<List<ProofingMakeProcessMaterial>>() {
        });

        /*
         * 将样品的相关工艺工序等删除
         */
        List<ProofingMakeTechnology> technologiesToDelete = proofingMakeTechnologyRepository.findAllByProofingMakeId(proofingMakeBaseInfo.getProofingMakeId());
        if (!technologiesToDelete.isEmpty()) {
            ProofingMakeTechnology technologyToDelete = technologiesToDelete.get(0);
            String proofingMakeTechnologyId = technologyToDelete.getProofingMakeTechnologyId();

            List<ProofingMakeProcessMaterial> proofingMakeTechnologyList = proofingMakeProcessMaterialRepository.findAllByProofingMakeTechnologyId(proofingMakeTechnologyId);
            proofingMakeProcessMaterialRepository.deleteInBatch(proofingMakeTechnologyList);

            List<ProofingMakeProcess> processesToDelete = proofingMakeProcessRepository.findAllByProofingMakeTechnologyId(proofingMakeTechnologyId);
            proofingMakeProcessRepository.deleteInBatch(processesToDelete);

            proofingMakeTechnologyRepository.delete(technologyToDelete);
        }

        proofingMakeTechnology.setProofingMakeId(proofingMakeBaseInfo.getProofingMakeId());
        proofingMakeTechnology = proofingMakeTechnologyRepository.save(proofingMakeTechnology);

        for (ProofingMakeProcess proofingMakeProcess : ProcessList) {
            proofingMakeProcess.setProofingMakeProcessId(null);
            proofingMakeProcess.setProofingMakeTechnologyId(proofingMakeTechnology.getProofingMakeTechnologyId());
            proofingMakeProcessRepository.save(proofingMakeProcess);
        }
        for (ProofingMakeProcessMaterial proofingMakeProcessMaterial : processMaterialList) {
            proofingMakeProcessMaterial.setProofingMakeProcessMaterialId(null);
            proofingMakeProcessMaterial.setProofingMakeTechnologyId(proofingMakeTechnology.getProofingMakeTechnologyId());
            proofingMakeProcessMaterialRepository.save(proofingMakeProcessMaterial);
        }

        String productId = proofingMakeBaseInfo.getProductId();

        // 保存BOM信息
        // 获取前端传来的BOM列表
        String bomJson = sdo.getString("bom");
        String status = "I";

        // 判断是否为新增还是修改
        ProofingMakeBom proofingMakeBom1 = new ProofingMakeBom();
        proofingMakeBom1.setProofingMakeId(idMap.get("proofingMakeId").toString());
        List<ProofingMakeBom> makeBomList = proofingMakeBomRepository.findAll(Example.of(proofingMakeBom1));
        if (!makeBomList.isEmpty()) {
            status = "U";
            // 修改 -- 删除
            makeBomList.forEach(proofingApplyBom -> proofingMakeBomRepository.delete(proofingApplyBom.getProofingMakeBomId()));
        }
        List<ProofingMakeBom> proofingMakeBomList = objectMapper.readValue(bomJson, new TypeReference<List<ProofingMakeBom>>() {
        });
        // 封装保存
        proofingMakeBomList.forEach(proofingMakeBom -> {
            proofingMakeBom.setProofingMakeId(idMap.get("proofingMakeId").toString());
            // 保存
            proofingMakeBomRepository.save(proofingMakeBom);
//            proofingMakeBom.setProductMaterialName(null);
        });

        // 给SAP返回BOM-JSON数据
        List<Map<String, Object>> boms = getReturnBOM(proofingMakeBomList);

        List<ProofingMakeReturn> param = saveToProduct(productId, sdo, boms, status);
        // 发送
        // TODO 接口地址未定
        String url = SystemCache.getParameter("sap.service.null.url", String.class);

        try {
            // TODO 返回数据未封装
            String execute = httpClient.execute(param, url);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return idMap;
    }

    @Override
    public ProofingMakeVo getProofingMakeVoById(String proofingMakeId) {
        ProofingMakeVo proofingMakeVo = new ProofingMakeVo();
        ProofingMakeBaseInfo proofingMake = proofingMakeRepository.findOne(proofingMakeId);
        if (proofingMake == null) return null;
        ProofingMakeLooked proofingMakeLooked = proofingMakeLookedRepository.findByProofingMakeId(proofingMakeId);
        ProofingMakePdPublishedConf proofingMakePdPublishedConf = proofingMakePdPublishedConfRepository.findByProofingMakeId(proofingMakeId);
        MyBaseUtil.mergeObjects(proofingMakeVo,
                proofingMake,
                proofingMakeLooked,
                proofingMakePdPublishedConf);
        return proofingMakeVo;
    }

    /**
     * 映射打样制造和打样申请 除前缀不一样的字段
     *
     * @param vo
     * @throws IllegalAccessException
     */
    public Map<String, Object> mappingReplacementMap(ProofingMakeVo vo) throws IllegalAccessException {
        Map<String, Object> proofingMake = new HashMap<>();

        Class<?> proofingApplyClass = vo.getClass();
        Field[] fields = proofingApplyClass.getDeclaredFields();

        for (Field field : fields) {
            field.setAccessible(true);
            String name = field.getName();
            if (!name.equals("proofingApplyId") && !name.equals("proofingApplyNo") && !name.equals("proofingApplyApplicationStatus")) {
                Object value = field.get(vo);
                String proofingMakeName = name.replaceFirst("^proofingApply", "proofingMake");
                proofingMake.put(proofingMakeName, value);
            } else {
                Object value = field.get(vo);
                proofingMake.put(name, value);
            }
        }
        return proofingMake;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void deleteProofingMakeById(String id) {
        ProofingMakeBaseInfo proofingMakeBaseInfo = proofingMakeRepository.findOne(id);
        proofingMakeBaseInfo.setIsDelete("1");
        proofingMakeRepository.save(proofingMakeBaseInfo);
    }

    /**
     * 返回JSON数据
     *
     * @return
     */
    public List<Map<String, Object>> getReturnBOM(List<ProofingMakeBom> bomJson) throws JsonProcessingException {
        List<Map<String, Object>> returnBOMList = new ArrayList<>();
        for (ProofingMakeBom proofingMakeBom : bomJson) {
            Map<String, Object> map = new HashMap<>();
            map.put("IDNRK", proofingMakeBom.getProductMaterialId());
            map.put("MENGE", proofingMakeBom.getProofingMakeBomNum());
            map.put("MEINS", proofingMakeBom.getProofingMakeBomMeins());
            map.put("AUSCH", proofingMakeBom.getProofingMakeBomAusch());
            map.put("POTX1", proofingMakeBom.getProofingMakeBomText());
            map.put("POTX2", proofingMakeBom.getProofingMakeBomMaterialText());
            map.put("ALPGR", proofingMakeBom.getProofingMakeBomAlpgr());
            map.put("ALPRF", proofingMakeBom.getProofingMakeBomAlprf());
            map.put("ALPST", proofingMakeBom.getProofingMakeBomAlpst());
            map.put("EWAHR", proofingMakeBom.getProofingMakeBomEwahr());
            returnBOMList.add(map);
        }
        return returnBOMList;
    }

    @Override
    @Transactional
    public void deleteProofingMakeByIds(List<String> ids) {
        ids.forEach(this::deleteProofingMakeById);
    }

    /**
     * 将make中的数据保存到商品中
     *
     * @return
     */
    public List<ProofingMakeReturn> saveToProduct(String productId, SDO sdo, List<Map<String, Object>> returnJson, String status) throws JsonProcessingException {
        String bomJson = sdo.getString("bom");
        ObjectMapper objectMapper = new ObjectMapper();
        //编辑产品信息
        // 产品外观
        ProductLooked productLooked = sdo.toObject(ProductLooked.class); // 获取make中的外观数据
        ProductLooked productLookedByProductId = productLookedRepository.findByProductId(productId); // 根据产品id获取原有信息
        productLooked.setProductLookedId(productLookedByProductId == null ? null : productLookedByProductId.getProductLookedId().toString());
        productLookedRepository.save(productLooked);

        // 产品打样排版参数设置
        ProductPublishedConf productPublishedConf = sdo.toObject(ProductPublishedConf.class);
        ProductPublishedConf productPublishedConfByProductId = productPublishedConfRepository.findByProductId(productId);
        productPublishedConf.setProductPublishedConfId(productPublishedConfByProductId == null ? null : productPublishedConfByProductId.getProductPublishedConfId().toString());
        productPublishedConfRepository.save(productPublishedConf);

        // 产品
        Product product = productRepository.findOne(productId);
        // 物料组成
        // TODO 原表中数据的转存问题
        List<ProductMaterial> productMaterialList = objectMapper.readValue(bomJson, new TypeReference<List<ProductMaterial>>() {
        });
        // 删除原表中的数据
        List<ProductMaterial> productMaterialByProductId = productMaterialRepository.findByProductId(productId);
        if (!productMaterialByProductId.isEmpty()) {
            productMaterialByProductId.forEach(productMaterial -> {
                productMaterialRepository.delete(productMaterial.getMaterialId());
            });
        }

        // 保存
        productMaterialList.forEach(productMaterial -> {
            productMaterial.setProductId(productId);
            productMaterial.setBomType("M");
            productMaterial.setBomVersion("v1.0");
            // 查询物料code

            productMaterialRepository.saveAndFlush(productMaterial);
        });

        // 产品工艺
        ProductTechnology productTechnology = sdo.toObject(ProductTechnology.class);
        ProductTechnology productTechnologyByProductId = productTechnologyRepository.findByProductId(productId);
        String productTechnologyId = productTechnologyByProductId.getProductTechnologyId();
        // null,表示无限制，true表示若父类中属性值为空则忽略，不传给子类
        CopyOptions copyOption = CopyOptions.create(null, true);
        BeanUtil.copyProperties(productTechnology, productTechnologyByProductId, copyOption);

        productTechnologyRepository.save(productTechnologyByProductId);

        // 产品工艺工序
        List<ProductProcess> productProcessList = objectMapper.readValue(bomJson, new TypeReference<List<ProductProcess>>() {
        });
        List<ProductProcess> byProductTechnologyId = productProcessRepository.findByProductTechnologyId(productTechnologyId);
        for (ProductProcess productProcess : productProcessList) {
            for (ProductProcess process : byProductTechnologyId) {
                if (Objects.equals(productProcess.getProductProcessId(), process.getProductProcessId())) {
                    BeanUtil.copyProperties(process, productProcess, copyOption);
                    BeanUtil.copyProperties(productProcess, process, copyOption);
                }
            }
            productProcessRepository.save(productProcess);
        }

        // 产品详细信息
//        ProductDetail productDetail = sdo.toObject(ProductDetail.class);
        ProofingMakeBaseInfo proofingMakeBaseInfo = sdo.toObject(ProofingMakeBaseInfo.class);
        ProductDetail productDetail = ToProductDetail(proofingMakeBaseInfo, productId);
        productDetailRepository.save(productDetail);

        // 封装数据
        ProofingMakeReturn proofingMakeReturn = new ProofingMakeReturn();
        BeanUtil.copyProperties(productLooked, proofingMakeReturn);
        BeanUtil.copyProperties(productPublishedConf, proofingMakeReturn);
        BeanUtil.copyProperties(product, proofingMakeReturn);
        BeanUtil.copyProperties(productTechnology, proofingMakeReturn);

        proofingMakeReturn.setBOMItems(returnJson);
        proofingMakeReturn.setUPDKZ(status);

        List<ProofingMakeReturn> proofingMakeReturns = new ArrayList<>();
        proofingMakeReturns.add(proofingMakeReturn);

        return proofingMakeReturns;
    }

    private ProductDetail ToProductDetail(ProofingMakeBaseInfo proofingMakeBaseInfo, String productId) {
        ProductDetail productDetail = productDetailRepository.findByProductId(productId);
        productDetail.setProductLayout(proofingMakeBaseInfo.getPage());
        productDetail.setProductEnglishName(proofingMakeBaseInfo.getProofingMakeSampleEnName());
        productDetail.setProductShortName(proofingMakeBaseInfo.getProofingMakeSampleCnName());
        productDetail.setProductNo(proofingMakeBaseInfo.getProofingMakeProductNo());
        productDetail.setCustomerMaterialCode(proofingMakeBaseInfo.getCustomerCode());
        return productDetail;
    }
}




