package com.huigou.topsun.proofing.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.proofing.application.ProofingApplyBomApplication;
import com.huigou.topsun.proofing.domain.proofingApply.query.ProofingApplyBomQueryRequest;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * title:
 * author:ZHT
 * date:2024/1/3
 * description:
 */
@Service
public class ProofingApplyBomApplicationImpl extends BaseApplication implements ProofingApplyBomApplication {
    @Override
    public Map<String, Object> slicedProofingApplyBom(ProofingApplyBomQueryRequest proofingApplyBomQueryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedProofingApplyBom");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, proofingApplyBomQueryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);

        // 转化为前端可以接受的数据
        ArrayList<HashMap> rows = (ArrayList) map.get("Rows");
        ArrayList<HashMap<String, Object>> proofingApplyBoms = new ArrayList<>();
        for (HashMap row : rows) {
            HashMap<String, Object> rowMap = new HashMap<>();
            rowMap.put("ALPGR", row.get("proofingApplyBomAlpgr"));
            rowMap.put("materialName", row.get("productMaterialName"));
            rowMap.put("materialNumber", row.get("proofingApplyBomNum"));
            rowMap.put("AUSCH", row.get("proofingApplyBomAusch"));
            rowMap.put("POTX1", row.get("proofingApplyBomText"));
            rowMap.put("materialJson", row.get("proofingApplyBomMaterialText"));
            rowMap.put("ALPRF", row.get("proofingApplyBomAlprf"));
            rowMap.put("ALPST", row.get("proofingApplyBomAlpst"));
            rowMap.put("EWAHR", row.get("proofingApplyBomEwahr"));
            rowMap.put("materialId", row.get("productMaterialId"));
            rowMap.put("materialUnit", row.get("proofingApplyBomMeins"));
            rowMap.put("ITEM_NUMBRE",row.get("proofingApplyBomItemNumber"));
            rowMap.put("CATEGORY",row.get("proofingApplyBomCategory"));
            rowMap.put("PROCURE",row.get("proofingApplyBomProcure"));
            rowMap.put("NOTE",row.get("proofingApplyBomNote"));
            rowMap.put("bomId", row.get("proofingApplyBomId"));
            rowMap.put("primaryKey",row.get("proofingApplyId"));
            proofingApplyBoms.add(rowMap);
        }
        map.remove("Rows");
        map.put("Rows", proofingApplyBoms);
        return map;
    }
}
