package com.huigou.topsun.product.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * title: 转正数据传SAP接口
 * author:ZHT
 * date:2024/1/8
 * description:
 */
public class ProductReturn implements Serializable {
    /**
     * 产品编码
     */
    @JsonProperty("MATNR")
    private String productCode;

    /**
     * 产品名称
     */
    @JsonProperty(value = "MAKTX",required = true)
    private String productName;

    /**
     * 产品数量
     */
    @JsonProperty(value = "BMENG",required = true)
    private String productNumber;

    /**
     * 产品计量单位
     */
    @JsonProperty(value = "BMEIN",required = true)
    private String productUnit;

    /**
     * BOM有效起始日期
     */
    @JsonProperty(value = "DATUV",required = true)
    private Date productDatuy;

    /**
     * ECN号
     */
    @JsonProperty(value = "AENNR",required = true)
    private String productAennr;

    /**
     * 单层厚(单位丝)
     */
    @JsonProperty(value = "ZDCH",required = true)
    private Integer productSingleLayer;

    /**
     * 单重(单位KG)
     */
    @JsonProperty(value = "ZDANZ",required = true)
    private Double productSingleWeight;

    /**
     * 行数
     */
    @JsonProperty(value = "ZPBHS",required = true)
    private Integer rowNum;

    /**
     * 派工倍数
     */
    @JsonProperty(value = "ZPGBS",required = true)
    private Integer dispatchMultiple;

    /**
     * 更新标识
     */
    @JsonProperty(required = true)
    private String  UPDKZ;

    /**
     * bom结点
     */
    private List<Map<String ,Object >> BOMItems;

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductNumber() {
        return productNumber;
    }

    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    public String getProductUnit() {
        return productUnit;
    }

    public void setProductUnit(String productUnit) {
        this.productUnit = productUnit;
    }

    public Date getProductDatuy() {
        return productDatuy;
    }

    public void setProductDatuy(Date productDatuy) {
        this.productDatuy = productDatuy;
    }

    public String getProductAennr() {
        return productAennr;
    }

    public void setProductAennr(String productAennr) {
        this.productAennr = productAennr;
    }

    public Integer getProductSingleLayer() {
        return productSingleLayer;
    }

    public void setProductSingleLayer(Integer productSingleLayer) {
        this.productSingleLayer = productSingleLayer;
    }

    public Double getProductSingleWeight() {
        return productSingleWeight;
    }

    public void setProductSingleWeight(Double productSingleWeight) {
        this.productSingleWeight = productSingleWeight;
    }

    public Integer getRowNum() {
        return rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public Integer getDispatchMultiple() {
        return dispatchMultiple;
    }

    public void setDispatchMultiple(Integer dispatchMultiple) {
        this.dispatchMultiple = dispatchMultiple;
    }

    public String getUPDKZ() {
        return UPDKZ;
    }

    public void setUPDKZ(String UPDKZ) {
        this.UPDKZ = UPDKZ;
    }

    public List<Map<String, Object>> getBOMItems() {
        return BOMItems;
    }

    public void setBOMItems(List<Map<String, Object>> BOMItems) {
        this.BOMItems = BOMItems;
    }

    public ProductReturn() {
    }

    public ProductReturn(String productCode, String productName, String productNumber, String productUnit, Date productDatuy, String productAennr, Integer productSingleLayer, Double productSingleWeight, Integer rowNum, Integer dispatchMultiple, String UPDKZ, List<Map<String, Object>> BOMItems) {
        this.productCode = productCode;
        this.productName = productName;
        this.productNumber = productNumber;
        this.productUnit = productUnit;
        this.productDatuy = productDatuy;
        this.productAennr = productAennr;
        this.productSingleLayer = productSingleLayer;
        this.productSingleWeight = productSingleWeight;
        this.rowNum = rowNum;
        this.dispatchMultiple = dispatchMultiple;
        this.UPDKZ = UPDKZ;
        this.BOMItems = BOMItems;
    }
}
