package com.huigou.topsun.product.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;


/**
 * @Auther: xin.lu
 * @Date: 2024/01/05/14:43
 * @Description:
 */
@Data
public class ProductAllDataVo {

    private String productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品类别
     */
    //@JsonSerialize(using = NumberToStringSerializer.class)
    private String productCategoryId;

    /**
     * 产品类别
     */
    //@JsonSerialize(using = NumberToStringSerializer.class)
    private String productCategoryName;

    /**
     * 产品状态(码表status)
     */
    private String productStatus;

    /**
     * 产品数量
     */
    private String productNumber;

    /**
     * 产品计量单位
     */
    private String productUnit;

    /**
     * BOM有效起始日期
     */
    private Date productDatuy;


    /**
     * ECN号
     */
    private String productAennr;
    /**
     * 样品编号
     */
    private String productSampleCode;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 产品类型(prodcut_type)
     */
    private String productType;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 尺码组id
     */
    private String productSizeGroupId;

    /**
     * 是否为唯一码产品
     */
    private String isOnlyCode;

    /**
     * 是否不考虑形体配色
     */
    private String isBodyColor;

    /**
     * 是否禁用
     */
    private String isDisable;

    /**
     * 是否建立bom表
     */
    private String isBuildBom;

    /**
     * 确认日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private java.util.Date confirmDate;

    /**
     * 确认人
     */
    private String comfirmPerson;

    /**
     * 是否免检
     */
    private String isFreeInspection;

    /**
     * 不要质量loss%
     */
    private String isNoQualityLoss;

    /**
     * 样品单号
     */
    private String sampleOrderNo;

    /**
     * 库存编码
     */
    private String stockNo;

    /**
     * 库存名称
     */
    private String stockName;

    /**
     * 存档编号
     */
    private String fileNo;

    //产品详情字段

    /**
     * 产品详情
     */
    private String productDetailId;

    /**
     * 工厂名称
     */
    private String factoryName;

    /**
     * 版面(product_layout)
     */
    private String productLayout;

    /**
     * 英文名
     */
    private String productEnglishName;

    /**
     * 产品简称
     */
    private String productShortName;

    /**
     * 产品背面ID
     */
    private String backProductFaceId;

    /**
     * 产品正面ID
     */
    private String rightProductFaceId;

    /**
     * 产品承印物
     */
    private String productSubstrate;

    /**
     * 材料代号
     */
    private String materialCode;

    /**
     * 产品代号
     */
    private String productNo;

    /**
     * 英文代号
     */
    private String productEnCode;

    /**
     * 型体配色
     */
    private String bodyColor;

    /**
     * 客户料号
     */
    private String customerMaterialCode;

    /**
     * 版本号
     */
    private String versionNo;

    /**
     * 是否创建新规格书
     */
    private String isNewSpecification;

    /**
     * 规格书编号
     */
    private String specificationNo;

    //产品外观字段

    private String productLookedId;

    /**
     * 长;单位cm
     */
    private Double productLength;

    /**
     * 宽;单位cm
     */
    private Double productWidth;

    /**
     * 高;单位cm
     */
    private Double productHeight;

    /**
     * 厚度;单位mm
     */
    private Double productThick;

    /**
     * 成品克重;单位g
     */
    private Double productWeight;

    /**
     * 角型
     */
    private String productAngleType;

    /**
     * 角度(单位mm)
     */
    private Double productAngle;

    /**
     * 孔径(单位mm)
     */
    private Double productAperture;

    /**
     * 单层厚(单位丝)
     */
    private Integer productSingleLayer;

    /**
     * 单重(单位KG)
     */
    private Double productSingleWeight;

    /**
     * 层数
     */
    private Integer productLayerNum;

    /**
     * 是否防霉(is_open)
     */
    private String productMould;

    /**
     * 是否写码(is_open)
     */
    private String productCoding;

    /**
     * 体系认证(product_sys_certification)
     */
    private String productSysCertification;

    /**
     * 仓库(store_name)
     */
    private String storeName;

    /**
     * 采购单位(product_buy_unit)
     */
    private String productBuyUnit;

    /**
     * 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；
     */
    private String productShape;

    /**
     * 样品形状大小（mm）
     */
    private Double prodcutShapeSize;

    /**
     * 采购换算值
     */
    private Double purchaseConversionValue;

    /**
     * 系数
     */
    private Double coefficient;

    private String productPublishedConfId;

    //产品参数配置字段
    /**
     * 模数
     */
    private Integer modulus;

    /**
     * 行数
     */
    private Integer rowNum;

    /**
     * 列数
     */
    private Integer columnNum;

    /**
     * 搭版数
     */
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    private Double sheetWidth;

    /**
     * 产品印张设置(product_sheet_conf)
     */
    private String productSheetConf;


    //产品工艺字段
    private String productTechnologyId;

    /**
     * 工艺路线id
     */
    private String technologyId;

    /**
     * 产品工艺制程
     */
    private String productTechnologyName;

    /**
     * 产品性质
     */
    private String productProperty;

    /**
     * 工艺要求
     */
    private String productTechnologyRequire;

    /**
     * 啤版编号
     */
    private String beerPlateNo;

    /**
     * 烫金版编号
     */
    private String goldPlateNo;

    /**
     * 模切版编号
     */
    private String dieCutPlateNo;

    /**
     * 铜版及树脂版编号
     */
    private String copperpResinLateNo;

    /**
     * 网版编号
     */
    private String netPlateNo;

    /**
     * 包装方式
     */
    private String packageStyle;

    /**
     * 物性测试
     */
    private String physicalTest;

    /**
     * 化性测试
     */
    private String chemistryTest;

    /**
     * 产品材质
     */
    private String productMaterial;

    /**
     * 塑胶袋结构
     */
    private String plasticBagStructure;

    /**
     * 铜版编号
     */
    private String copperpNo;

    /**
     * 色号卡
     */
    private String colorNoCard;

    /**
     * 模具编号
     */
    private String plateNo;

    /**
     * 表面处理
     */
    private String surfaceTreatment;

    /**
     * 产品描述
     */
    private String productDescribe;

    /**
     * 产品正面
     */
    private String productFront;

    /**
     * 产品背面
     */
    private String productOpposite;

    /**
     * 风险描述（序号、内容、等级）
     */
    private String riskDescription;

    /**
     * 是否附样图
     */
    private String haveDrawing;

    /**
     * 是否要鞋图
     */
    private String isShoePicture;

    /**
     * 啤板模数
     */
    private Integer beerPlateNum;

    /**
     * 模切板模数
     */
    private Integer dieBoardNum;

    /**
     * 分切方向
     */
    private String cutDirection;

    /**
     * 海关商品编码
     */
    private String customsCommodityCode;

    /**
     * 物料ID
     */
    private String materialId;

    /**
     * 物料名称
     */
    private String materialName;

    /**
     * 物料数量
     */
    private Integer materialNumber;

    /**
     * 组件计量单位
     */
    private String materialUnit;

    /**
     * 组件报废百分比
     */
    private Double materialAusch;

    /**
     * BOM项目文本
     */
    private String materialPotx1;

    /**
     * 物料清单文本
     */

    private String materialJson;

    /**
     * 替代组
     */
    private String materialAlpgr;

    /**
     * 替代优先级
     */
    private String materialAlprf;

    /**
     * 策略
     */
    private String materialAlpst;

    /**
     * 使用概率
     */
    private String materialEwahr;

    /**
     * BOM版本
     */
    private String bomVersion;

    /**
     * 产品BOM类型(bom_type)
     */
    private String bomType;

    /**
     * 物料项次
     */
    private String materialItemNumber;

    /**
     * 物料类别
     */
    private String materialCategory;

    /**
     * 采购
     */
    private String materialProcure;

    /**
     * 备注
     */
    private String materialNote;
}
