package com.huigou.topsun.product.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/05/11:14
 * @Description:
 */
@Data
public class ProductQueryRequest extends QueryAbstractRequest {
    /**
     * 产品编号
     */
    private String productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品英文名
     */
    private String productEnglishName;

    /**
     * 产品类别
     */
    private String productCategoryId;

    private String productCategoryName;


    /**
     * 产品类型
     */
    private String productType;

    /**
     * 产品品牌
     */
    private String brandName;

    /**
     * 产品状态(码表status)
     */
    private String productStatus;

    /**
     * 产品数量
     */
    private String productNumber;

    /**
     * 产品计量单位
     */
    private String productUnit;

    /**
     * BOM有效起始日期
     */
    private Date productDatuy;

    /**
     * ECN号
     */
    private String productAennr;

    /**
     * 样品编号
     */
    private String productSampleCode;

    private String productTechnologyId;

    private String face;
}
