package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author YourUserName
 * 产品物料组成
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_material")
public class ProductMaterial implements Serializable {

    /**
     * 产品物料组成ID
     */
    @Id
    //@JsonSerialize(using = NumberToStringSerializer.class)
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "product_material_id", nullable = false)
    private String productMaterialId;

    /**
     * 产品ID
     */
    //@JsonSerialize(using = NumberToStringSerializer.class)
    @Column(name = "product_id", nullable = true)
    private String productId;

    /**
     * 物料ID
     */
    @Column(name = "material_id", nullable = true, length = 32)
    private String materialId;
    /**
     * 物料编码
     */
    @Column(name = "material_code", nullable = true, length = 32)
    private String materialCode;
    /**
     * 物料名称
     */
    @Column(name = "material_name", nullable = true, length = 32)
    private String materialName;

    /**
     * 物料数量
     */
    @Column(name = "material_number", nullable = true)
    private Integer materialNumber;

    /**
     * 组件计量单位
     */
    @Column(name = "material_unit")
    private String materialUnit;

    /**
     * 组件报废百分比
     */
    @Column(name = "material_ausch")
    @JsonProperty(value = "AUSCH",required = true)
    private Double materialAusch;

    /**
     * BOM项目文本
     */
    @Column(name = "material_potx1")
    @JsonProperty(value = "POTX1",required = true)
    private String materialPotx1;

    /**
     * 物料清单文本
     */
    @Column(name = "material_json")
    private String materialJson;

    /**
     * 替代组
     */
    @Column(name = "material_alpgr")
    @JsonProperty(value = "ALPGR",required = true)
    private String materialAlpgr;

    /**
     * 替代优先级
     */
    @Column(name = "material_alprf")
    @JsonProperty(value = "ALPRF",required = true)
    private String materialAlprf;

    /**
     * 策略
     */
    @Column(name = "material_alpst")
    @JsonProperty(value = "ALPST",required = true)
    private String materialAlpst;

    /**
     * 使用概率
     */
    @Column(name = "material_ewahr")
    @JsonProperty(value = "EWAHR",required = true)
    private String materialEwahr;

    /**
     * BOM版本
     */
    @Column(name = "bom_version", nullable = true, length = 128)
    private String bomVersion;

    /**
     * 产品BOM类型(bom_type)
     */
    @Column(name = "bom_type", nullable = true, length = 32)
    private String bomType;

    /**
     * 物料项次
     */
    @Column(name = "material_item_number")
    @JsonProperty(value = "ITEM_NUMBRE", required = true)
    private String materialItemNumber;

    /**
     * 物料类别
     */
    @Column(name = "material_category")
    @JsonProperty(value = "CATEGORY", required = true)
    private String materialCategory;

    /**
     * 采购
     */
    @Column(name = "material_procure")
    @JsonProperty(value = "PROCURE", required = true)
    private String materialProcure;


    /**
     * 备注
     */
    @Column(name = "material_note")
    @JsonProperty(value = "NOTE", required = true)
    private String materialNote;

    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }

    public String getMaterialJson() {
        return materialJson;
    }

    public void setMaterialJson(String materialJson) {
        this.materialJson = materialJson;
    }

    public String getMaterialItemNumber() {
        return materialItemNumber;
    }

    public void setMaterialItemNumber(String materialItemNumber) {
        this.materialItemNumber = materialItemNumber;
    }

    public String getMaterialCategory() {
        return materialCategory;
    }

    public void setMaterialCategory(String materialCategory) {
        this.materialCategory = materialCategory;
    }

    public String getMaterialProcure() {
        return materialProcure;
    }

    public void setMaterialProcure(String materialProcure) {
        this.materialProcure = materialProcure;
    }

    public String getMaterialNote() {
        return materialNote;
    }

    public void setMaterialNote(String materialNote) {
        this.materialNote = materialNote;
    }


    public String getProductMaterialId() {
        return productMaterialId;
    }

    public void setProductMaterialId(String productMaterialId) {
        this.productMaterialId = productMaterialId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Integer getMaterialNumber() {
        return materialNumber;
    }

    public void setMaterialNumber(Integer materialNumber) {
        this.materialNumber = materialNumber;
    }


    public Double getMaterialAusch() {
        return materialAusch;
    }

    public void setMaterialAusch(Double materialAusch) {
        this.materialAusch = materialAusch;
    }

    public String getMaterialPotx1() {
        return materialPotx1;
    }

    public void setMaterialPotx1(String materialPotx1) {
        this.materialPotx1 = materialPotx1;
    }

    public String getMaterialAlpgr() {
        return materialAlpgr;
    }

    public void setMaterialAlpgr(String materialAlpgr) {
        this.materialAlpgr = materialAlpgr;
    }

    public String getMaterialAlprf() {
        return materialAlprf;
    }

    public void setMaterialAlprf(String materialAlprf) {
        this.materialAlprf = materialAlprf;
    }

    public String getMaterialAlpst() {
        return materialAlpst;
    }

    public void setMaterialAlpst(String materialAlpst) {
        this.materialAlpst = materialAlpst;
    }

    public String getMaterialEwahr() {
        return materialEwahr;
    }

    public void setMaterialEwahr(String materialEwahr) {
        this.materialEwahr = materialEwahr;
    }

    public String getBomVersion() {
        return bomVersion;
    }

    public void setBomVersion(String bomVersion) {
        this.bomVersion = bomVersion;
    }

    public String getBomType() {
        return bomType;
    }

    public void setBomType(String bomType) {
        this.bomType = bomType;
    }
}
