package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品loss配置
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_loss")
public class ProductLoss implements Serializable {

	/**
	 * 产品lossID
	 */
	@Id
	//@JsonSerialize(using = NumberToStringSerializer.class)
	@GeneratedValue(generator = "system-uuid")
	@GenericGenerator(name = "system-uuid", strategy = "guid")
	@Column(name = "product_loss_id", nullable = false)
	private String productLossId;

	/**
	 * 产品ID
	 */
	//@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = true)
	private String productId;

	/**
	 * 产品最大loss数量
	 */
	@Column(name = "product_loss_max", nullable = true)
	private Integer productLossMax;

	/**
	 * loss比率(单位%)
	 */
	@Column(name = "product_loss_rate", nullable = true)
	private Double productLossRate;

	/**
	 * 冗余量
	 */
	@Column(name = "product_loss_redundance", nullable = true)
	private Double productLossRedundance;

	/**
	 * 备注信息
	 */
	@Column(name = "product_loss_remark", nullable = true, length = 512)
	private String productLossRemark;

	/**
	 * 客户名称
	 */
	@Column(name = "customer_name", nullable = true, length = 32)
	private String customerName;
	
	public String getProductLossId() {
		return this.productLossId;
	}
	
	public void setProductLossId (String  productLossId) {
		this.productLossId = productLossId;
	}
	
	public String getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = productId;
	}
	
	public Integer getProductLossMax() {
		return this.productLossMax;
	}
	
	public void setProductLossMax(Integer productLossMax) {
		this.productLossMax = productLossMax;
	}
	
	public Double getProductLossRate() {
		return this.productLossRate;
	}
	
	public void setProductLossRate(Double productLossRate) {
		this.productLossRate = productLossRate;
	}
	
	public Double getProductLossRedundance() {
		return this.productLossRedundance;
	}
	
	public void setProductLossRedundance(Double productLossRedundance) {
		this.productLossRedundance = productLossRedundance;
	}
	
	public String getProductLossRemark() {
		return this.productLossRemark;
	}
	
	public void setProductLossRemark(String productLossRemark) {
		this.productLossRemark = productLossRemark;
	}
	
	public String getCustomerName() {
		return this.customerName;
	}
	
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
}
