package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品版面颜色
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_face_color")
public class ProductFaceColor implements Serializable {

	/**
	 * 产品颜色ID
	 */
	@Id
	//@JsonSerialize(using = NumberToStringSerializer.class)
	@GeneratedValue(generator = "system-uuid")
	@GenericGenerator(name = "system-uuid", strategy = "guid")
	@Column(name = "product_face_color_id", nullable = false)
	private String productFaceColorId;

	/**
	 * 产品ID
	 */
	@Column(name = "product_id", nullable = true)
	private String productId;

	/**
	 * 产品版面ID
	 */
	@Column(name = "product_face_id", nullable = true, length = 32)
	private String productFaceId;

	/**
	 * 颜色ID
	 */
	@Column(name = "color_id", nullable = true, length = 32)
	private String colorId;

	@Column(name = "color_name")
	private String colorName;

	/**
	 * 覆盖率(单位%)
	 */
	@Column(name = "coverage_rate", nullable = true)
	private Double coverageRate;

	/**
	 * 排序序号
	 */
	@Column(name = "sort_order", nullable = true)
	private Integer sortOrder;

	/**
	 *正反面：正面 front  反面 back
	 */
	@Column(name = "face")
	private String face;

	public String getFace() {
		return face;
	}

	public void setFace(String face) {
		this.face = face;
	}

	public String getProductFaceColorId() {
		return this.productFaceColorId;
	}
	
	public void setProductFaceColorId (String  productFaceColorId) {
		this.productFaceColorId = productFaceColorId;
	}
	
	public String getProductFaceId() {
		return this.productFaceId;
	}
	
	public void setProductFaceId(String productFaceId) {
		this.productFaceId = productFaceId;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}
	
	public String getColorId() {
		return this.colorId;
	}
	
	public void setColorId(String colorId) {
		this.colorId = colorId;
	}
	
	public Double getCoverageRate() {
		return this.coverageRate;
	}
	
	public void setCoverageRate(Double coverageRate) {
		this.coverageRate = coverageRate;
	}
	
	public Integer getSortOrder() {
		return this.sortOrder;
	}
	
	public void setSortOrder(Integer sortOrder) {
		this.sortOrder = sortOrder;
	}

	public String getColorName() {
		return colorName;
	}

	public void setColorName(String colorName) {
		this.colorName = colorName;
	}
}
