package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品版面信息
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_face")
public class ProductFace implements Serializable {

	/**
	 * 产品版面ID
	 */
	@Id
	//@JsonSerialize(using = NumberToStringSerializer.class)
	@GeneratedValue(generator = "system-uuid")
	@GenericGenerator(name = "system-uuid", strategy = "guid")
	@Column(name = "product_face_id", nullable = false)
	private String productFaceId;

	/**
	 * 产品版面图片
	 */
	@Column(name = "product_image", nullable = true, length = 512)
	private String productImage;

	@Transient
	private Boolean isBack;

	@Column(name = "product_id")
	private String productId;

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ProductFace that = (ProductFace) o;
		return new EqualsBuilder().append(productFaceId, that.productFaceId).append(productImage, that.productImage).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(productFaceId).append(productImage).toHashCode();
	}

	public String getProductFaceId() {
		return this.productFaceId;
	}
	
	public void setProductFaceId (String  productFaceId) {
		this.productFaceId = productFaceId;
	}
	
	public String getProductImage() {
		return this.productImage;
	}
	
	public void setProductImage(String productImage) {
		this.productImage = productImage;
	}

	public Boolean getBack() {
		return isBack;
	}

	public void setBack(Boolean back) {
		isBack = back;
	}
}
